%
% Code-Beispiele für schnell mal was messen
%

clear;
daqlist()

messgeraet = daq('ni');
addinput(messgeraet, 'cDAQ4Mod1', 'ai0', 'Voltage');
addinput(messgeraet, 'cDAQ4Mod1', 'ai1', 'Voltage');
addinput(messgeraet, 'cDAQ4Mod1', 'ai2', 'Voltage');
messgeraet.Rate = 51200;
fs = messgeraet.Rate;
kali1 = 1.0993; % Beschleunigung in der Struktur %1.1154
kali2 = 1.1880; % Beschleunigung an der Krafteinleitung
kali3 = 10.47; % Krafteinleitung

% kalibrierung - caluclate rms(data(:,1)*1000)/10
% plot(time, data(:,1)) (from:to,Channel)

%
% normale Messung
[data, time] = read(messgeraet, seconds(5), 'outputFormat', 'Matrix');

plot(time, data*10000)

%
% Messung im Hintergrund in APP
%
%{
    app.messgeraet.ScansAvailableFcnCount = ceil(app.fs/app.refreshRate); % Größe des Datenpuffers
    app.messgeraet.ScansAvailableFcn = @(src,evt) datenverarbeitung(app, event);
  
    function datenverarbeitung(app, ~, ~)
            [data, time, ~] = read(app.messgeraet, app.messgeraet.ScansAvailableFcnCount,'OutputFormat','Matrix');
    end

    start(app.messgeraet, 'continuous');
%}

%
% Messdaten auf Festplatte streamen
%
%{
    %
    % Dateiname automatisieren
    %
    t = char(string(datetime));
    datei = [t(8:11) t(4:6) t(1:2) '_T' t(13:14) t(16:17) t(19:20) '.bin'];
    app.fileID=fopen(datei, 'w');

    %
    % Daten in Stream umsortieren
    %
    [zeilen, spalten] = size(data);
    pos = 1;
    
    for inc=1:zeilen
        stream(pos,1) = time(inc,1);
        pos = pos + 1;
        for chan=1:length(messpunkt)
            stream(pos,1) = data(inc,chan);
            pos = pos + 1;
        end
    end
    %
    % Daten streamen
    %
    fwrite(fileID, stream, 'double');
%}
%
% Messdaten aus Datei einlesen und wieder in Matrixform bringen
% dazu nuss die Anzahl der Messkanäle bekannt sein.
%{
    anzChan = 1;
    datei = '2022Jun28_T104039.bin';
    fileID = fopen(datei, 'r');
    daten = (fread(fileID,[anzChan+1 inf],'double'));
    fclose(fileID);

    time = daten(:,1);
    data = daten(:, 2:end);
%}