import machine
import mcp4725
import utime

def pwm(pin, freq):
    pwm = machine.PWM(machine.Pin(pin))
    pwm.freq(freq)
    return pwm

def winkel(servo, wert):
    if wert > 180:
        wert = 180
        
    if wert == 0:
        servo.duty_u16(8200)
        
    if wert > 0: 
        servo.duty_u16(int(8200-wert*6000/180))
        
def ventile():
    ventil0=machine.Pin(2, machine.Pin.OUT)
    ventil1=machine.Pin(3, machine.Pin.OUT)
    ventil2=machine.Pin(4, machine.Pin.OUT)
    ventil3=machine.Pin(5, machine.Pin.OUT)
    
    ventile = [ventil0, ventil1, ventil2, ventil3]
    
    return ventile

def ventil_on(ventile, nr):
    ventil = ventile[nr]
    ventil.on()
    
def ventil_off(ventile, nr):
    ventil = ventile[nr]
    ventil.off()
    
def adc(pin):
    adc = machine.ADC(machine.Pin(pin))
    return adc
    
def dac():
    i2c = machine.I2C(0, sda=machine.Pin(0), scl=machine.Pin(1), freq=400000)
    dac = mcp4725.MCP4725(i2c,mcp4725.BUS_ADDRESS[0])
    return dac

def taster():
    tasten = machine.Pin(22, machine.Pin.OUT)
    taste_l = machine.Pin(27, machine.Pin.IN, machine.Pin.PULL_DOWN)
    taste_r = machine.Pin(26, machine.Pin.IN, machine.Pin.PULL_DOWN)
    
    return [tasten, taste_l, taste_r]

def setup(pins):
    out1 = machine.Pin(pins[0], machine.Pin.OUT)
    out2 = machine.Pin(pins[1], machine.Pin.OUT)
    out3 = machine.Pin(pins[2], machine.Pin.OUT)
    out4 = machine.Pin(pins[3], machine.Pin.OUT)
    out1.value(0)
    out2.value(0)
    out3.value(0)
    out4.value(0)
    utime.sleep_us(750)
    
    return [out1, out2, out3, out4]


def setStepper(seq, out):
    out[0].value(seq[0])
    out[1].value(seq[1])
    out[2].value(seq[2])
    out[3].value(seq[3])
    utime.sleep_us(750)
    

def setStepperOff(out):
    setStepper([0,0, 0, 0], out)
    

def sequenz():
    seq1 = (0, 1, 0, 0)
    seq2 = (0, 1, 0, 1)
    seq3 = (0, 0, 0, 1)
    seq4 = (1, 0, 0, 1)
    seq5 = (1, 0, 0, 0)
    seq6 = (1, 0, 1, 0)
    seq7 = (0, 0, 1, 0)
    seq8 = (0, 1, 1, 0)
    
    return [seq1, seq2, seq3, seq4, seq5, seq6, seq7, seq8]
    

def forwardStep(steps, seq_pos, seq, out):
    
    xi = 0
    while xi < steps:
        xi = xi + 1
        seq_pos = seq_pos + 1
        
        if seq_pos == 8:
            seq_pos = 0
            
        setStepper(seq[seq_pos], out)
        
    return seq_pos


def backwardStep(steps, seq_pos, seq, out):
    
    xi = 0
    while xi < steps:
        xi = xi + 1
        
        seq_pos = seq_pos - 1
        
        if seq_pos < 0:
            seq_pos = 7    
            
        setStepper(seq[seq_pos], out)
        
    return seq_pos