%{
    Mod03_BerDatShaker.m
    
    Ansammlung an MATLAB-Anweisungen zur Bearbeitung von
    Impulshammer-Messungen um diese fr die Modalanalyse aufzubereiten.

    Dieses Skript wertet halbautomatisch Impulshammermessungen fr eine
    Modalanalyse aus.

    Die Ergebnisse werden in der Datenstruktur ergebnis abgelegt.
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 3. Dezember 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

%
% Ermittlung der Frequenzen und Dmpfungen
%
% bernahme der Frequenzen aus dem FRF-Plot

frequenzen = [30 78];

%
% den modalfit per Hand ausfhren
% und das subjektiv beste Ergebnis weiter verwenden
%

%[fn, dn] = modalfit(frf,f,fs,100,'FitMethod','lsce', 'FreqRange',[0 500], 'PhysFreq', frequenzen);
[fn, dn] = modalfit(frf,f,fs,100,'FitMethod','pp', 'FreqRange',[0 500], 'PhysFreq', frequenzen);
%[fn, dn] = modalfit(frf,f,fs,100,'FitMethod','lsrf', 'FreqRange',[0 500], 'PhysFreq', frequenzen);

%%
%
% Berechnung der fr die Schwingform bentigten Auslenkung
%

%
%   1. Ermittlung der Betragswerte der bertragungsfunktion bei den
%   Modal-Frequenzen
%

df =f(10,1)-f(9,1);         % Frequenzauflsung bestimmen
span = ceil(10/df);         % Spannweite fr die Maxima-Suche
freqs = 2;                  % Anzahl der Modal-Frequenzen
positionen = 6;             % Anzahl der Positionen
                            % diese Parameter knnen auch auf anderem wege
                            % programatisch bestimmt werden
                            % Bedingung ist, dass der Anregungs-Antwortpunkt n die
                            % erste Position ist

for r = 1:freqs
    dn_r = mean(dn(r,:));
    for pos = 1:positionen
        idx = ceil(fn(r,pos)/df);       % Ermittlung des Index fr die Resonanzfrequenz
                                        % Bestimmung des Betrags der
                                        % bertragungsfunktion
        HxF(r,pos) = max(abs(frf((idx-span):(idx+span),r)));
                                        % Ermittlung der Auslenkungsrichtung
        if min(imag(frf(idx-span:idx+span,r))) < 0
            Richtung(r,pos) = (-1);
        else
            Richtung(r,pos) = 1;
        end
        
        if pos == 1
                                        %
                                        %   Ermittlung der Auslenkung im Anregungs-Antwortpunkt 
                                        %   dieser Rechenschritt wird lediglich fr die Auswertung der
                                        %   Anregungs-Antwortpunkt-Messung  durchgefhrt
                                        %
            Phi(r,pos) = sqrt(HxF(r,pos)*((fn(r,pos)*2*pi)^2)*sqrt(dn_r^4+4*dn_r^2));
        else
                                        %
                                        %   Ermittlung der Auslenkung
                                        %   dieser Rechenschritt wird fr alles Anschlugpunkte auerhalb des
                                        %   Anregungs-Antwortpunkt-Messung durchgefhrt
                                        %
    
            Phi(r,pos) = sqrt(dn_r^4+4*dn_r^2)*HxF(r,pos)*((fn(r,pos)*2*pi)^2)/Phi(r,1);
        end
    end                                 % end - pos
end                                     % end - r
%%
%
% Datenablage
%

ergebnis.anregung = anregung;       % gewichtete Zeitreihe der Anregung
ergebnis.antwort = antwort;         % gewichtete Zeitreihe der Antwort
ergebnis.frf = frf;                 % berechnete bertragungsfunktion
ergebnis.f = f;                     % Frequenzvektor
ergebnis.fn = fn;                   % Frequenzen der Moden
ergebnis.D = dn;                    % Dmpfung der Moden
ergebnis.HxF = HxF;                 % Betragswerte der bertragungsfunktion der Moden
ergebnis.Phi = Phi;                 % Auslenkungen der Moden
ergebnis.Richtung = Richtung;       % Auslenkungsrichtung

%%

xAusgleich = 0:1:xKoordinate(1,end);

%
% Visualisierung
%
hold on
plot(xKoordinate(1,2:end), ergebnis.Phi(1,2:end)-mean(ergebnis.Phi(1,2:end)),'*b', 'LineWidth', 4);
plot(xKoordinate(1,2:end), ergebnis.Phi(2,2:end)-mean(ergebnis.Phi(2,2:end)),'+r', 'LineWidth', 4);

PhiAusgleich = interp1(xKoordinate,ergebnis.Phi(1,:),xAusgleich,'spline');
plot(xAusgleich, PhiAusgleich-mean(PhiAusgleich),'b', 'LineWidth', 2);

PhiAusgleich = interp1(xKoordinate,ergebnis.Phi(2,:),xAusgleich,'spline');
plot(xAusgleich, PhiAusgleich-mean(PhiAusgleich),'r', 'LineWidth', 2);
hold off
set(gca, 'FontSize', 16)
set(gca, 'ygrid', 'on')
set(gca, 'xgrid', 'on')
legend('Mode 1: 30,3 Hz','Mode 2: 77,8 Hz')


axis([0 1300 -0.2 0.2])
title('Schwingform der Abgasanalge in Z-Richtung');
ylabel('Auslenkung [mm]');
xlabel('X-Koordinate der Abgasanlage [mm]');

set(figure(1),'Position',[50 900 1280 480]);