%{
    Mod01_ChirpRohdaten.m
    
    Ansammlung an MATLAB-Anweisungen zur Bearbeitung von
    Chirp-Messungen um diese fr die Modalanalyse aufzubereiten.

    Dieses Skript wertet halbautomatisch Impulshammermessungen fr eine
    Modalanalyse aus.

    Die Ergebnisse werden in der Datenstruktur ergebnis abgelegt.
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 3. Dezember 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%
clear antwort;

%{
clear;
load('20180208_AGA_Demodaten_Orig.mat');

%}

%
% fr die Berechnung der Schwingformen werden die Matrizzen anregung und 
% antwort die Abtastrate fs und die blocksize bentigt
%

fs = messung.stufe{1,1}.fs;
blocksize = length(messung.stufe{1,1}.Time);    % die blocksize entspricht der Vektorlnge des Zeitvektors

drivingPoint = 1;                               % Datensatz Nr des Driving Points
channels = [6 7 8 14 15 13];                    % fr die Auswertung relevante Kanle

for inc=1:length(channels)                      
                                                % bernahme der X-Koordinate fr die sptere Visualisierung
    xKoordinate(inc) = messung.messpunkt(channels(inc)).koord_X;
    
end


%
% Auswahl des Datensatzes
% auch ein Aneinanderhngen verschiedener Datenstze ist mglich
%

for inc=1:length(messung.stufe)
    if inc == 4
        for inc2 = 1:length(channels)
            antwort(:,inc2) = messung.stufe{1,inc}.Data(:,channels(inc2));
            anregung = messung.stufe{1,inc}.Data(:,1);
        end
    end
    %{
    if inc == 4
        for inc2 = 1:length(channels)
            buffer(:,inc2) = messung.stufe{1,inc}.Data(:,channels(inc2));
        end
        antwort = vertcat(antwort, buffer);
        anregung = vertcat(anregung, messung.stufe{1,inc}.Data(:,1));
    end
    %}
end

