function y = RectExpo(nfft, fs, rect, nrect, weighting, type) 

% 
%
% RectExpo are free software
% you can redistribute it and/or modify it under the terms of the 
% GNU General Public License as published by the Free Software Foundation;
% either version 2, or (at your option) any later version.
%
% RectExpo are distributed in the hope that it will be useful, 
% but without any warranty; without even the implied warranty of 
% merchantability or fitness for a particular purpose. See the GNU General
% Public License for more details.
%
%
%   Dipl.-Ing. Armin Rohnen LbA
%   Labor fr Maschinendynamik
%   Hochschule fr angewandte Wissenschaften Mnchen
%   University of applied sciences Munich
%
%   31. August 2015
%
%
%   Parameter und ihre Funktionalitt:
%   
%   nfft:                   Anzahl der Messwerte, gre des Fensters
%   fs:                     Abtastrate
%   rect: '%', 'time', 'n'  gibt an, wie die Angabe in nrect zu
%                           interpretieren ist
%                           %:      als Prozentangabe
%                           time:   als Zeitangabe in ms
%                           n:      als Anzahl der Messwerte
%   nrect:                  Lnge des Rect-Anteils
%   weighting:              Gewichtung der Abklingfunktion
%   type:                   gibt den Type der Abklingform an
%                           1:  LIN     lineares Abklingen
%                           2:  EXPO    Abklinkurve e^-t*weighting
%                                       dieses Fenster klingt nicht zwangsweise
%                                       mit 0 aus!
%                           3:  SIN     Abklingkurve sin(x)^2, weighting gibt
%                                       hier den Datenbereich in % an, ber den
%                                       sich die Abklingfunktion erstrecken
%                                       soll
%
%
%%

%
%
%   1. Rechteckanteil der Window-Function
%
%

if rect == '%'                      % bergabe in %
    n = floor(nrect/100 * nfft);
end;

if rect == 'time'                   % bergabe als Zeit
    n = floor(nrect/1000 * fs);
end;

if rect == 'n'                      % bergabe in Anzahl-Messwerte
    n = nrect;
end;

y(1,1)= 0;

for k=2:n
    y(k,1)= 1;
end;

weight = 1;

if type == 1                        % lineares Abklingen
    sprung = 1/(nfft-n);
    for k=n+1:nfft
        weight = weight - sprung;
        if weight < 1e-10
            weight = 0;
        end;
        y(k,1) = weight;
    end;
end;

if type == 2                        % exponentielles Abklingen
    sprung = (-5.3)/(nfft-n);       % normiert auf den Wertebereich 1 ... 0
    for k=n+1:nfft
        t = sprung * (k-n); 
        weight = exp(weighting*t);
        if weight < 1e-10
            weight = 0;
        end;
        y(k,1) = weight;
    end;
end;

if type == 3                        % Abklingverhalten nach sin(x)^2
    sprung = pi/(2*(nfft-n)*weighting/100);
    for k=n+1:nfft
        t = (pi/2)+sprung * (k-n);
        weight = sin(t)^2;
        if weight < 1e-10
            weight = 0;
        end;
        if (k-n) > (nfft-n)*weighting/100
            weight = 0;
        end;
        y(k,1) = weight;
    end;
end;
