%{
    Mod02_ImpulsBewerten.m
    
    Ansammlung an MATLAB-Anweisungen zur Bearbeitung von
    Impulshammer-Messungen um diese fr die Modalanalyse aufzubereiten.

    Dieses Skript wertet halbautomatisch Impulshammermessungen fr eine
    Modalanalyse aus.

    Die Ergebnisse werden in der Datenstruktur ergebnis abgelegt.
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 3. Dezember 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

%
% Zuschneiden der einzelnen Messungen
% Fr die sptere Modalanalyse-Auswertung werden passgerechte Daten
% bentigt. Der Impulsschlag muss dabei immer zum gleichen Zeitpunkt in der
% Zeitreihe positioniert sein. Dies wird durch Triggerung der Daten
% erreicht.
% Aus der Begutachtung der Rohdaten kann eine Abschtzung erfolgen wann das Objekt abgeklungen ist und demnach
% welche zeitlichen Lnge die Auswertedaten aufweisen sollen.
%

%position = 1;
%drivingPoint = 3;

fs = 1/(messung.pos(1,1).Time(100,1) - messung.pos(1,1).Time(99,1));
                                                        % Berechnung der Abtastrate aus dem Zeitvektor

laenge = 3;                                             % festgestellte Abklingzeit des Objekts in Sekunden

pre = 0.002;                                            % Pre-Trigger in s                  
df = 1/laenge;                                          % Frequenzauflsung
blocksize = ceil(fs * laenge);                         % Blocksize fr die fouriertransformation
npre = ceil(fs * pre);                                 % Anzahl der Messwerte vor dem Impuls

%subplot(1,2,1)
hold on
for inc=1:15
    for k=1:length(messung.pos(position,inc).Data(:,1))
        if(messung.pos(position,inc).Data(k,1)*1000/kaliHammer > 10)
            break;
        end
    end

    start = k-npre;
    stop = start+blocksize-1;
    antwortRoh(position,inc).Data = messung.pos(position,inc).Data(start:stop,2)*1000/kaliAufnehmer;
 
    anregungRoh(position,inc).Data = messung.pos(position,inc).Data(start:stop,1)*1000/kaliHammer;
    
    anregungRoh(position,inc).Breite = pulsewidth(anregungRoh(position,inc).Data,fs)*1000;      
                                                                            % Bestimmung der Impulsbreite in Millisekunden
    anregungRoh(position,inc).Hoehe = max(anregungRoh(position,inc).Data); 
                                                                            % Bestimmung der Impulshe
    plot(anregungRoh(position,inc).Breite, anregungRoh(position,inc).Hoehe, '+', 'LineWidth', 4);
        
end
hold off
axis([0.1 0.16 0 300]);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title('Impulshhen / Impulsbreiten');
ylabel('Impulshhe [N]');
xlabel('Impulsbreite [ms]');
