%{
    Mod06_Visu.m
    
    Darstellung der Moden
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 3. Dezember 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%
clear auslenkung;

modenNr = 3;

%
% Darstellungsvektor zusammenstellen
%

for inc=1:length(ergebnis.point)
    auslenkung(inc,1) = ergebnis.point(inc).Phi(modenNr)*ergebnis.point(inc).Richtung(modenNr);
    if inc == 1
        winkel(inc,1) = 0;
    else
        winkel(inc,1) = deg2rad((inc-1)/length(ergebnis.point)*360);
    end
end

auslenkung(inc+1,1) = auslenkung(1,1);
winkel(inc+1,1) = deg2rad((inc)/length(ergebnis.point)*360);

winkel_ausgleich = (winkel(1,1):pi/320:winkel(end,1))';
auslenkung_ausgleich = interp1(winkel,auslenkung,winkel_ausgleich,'spline');

polarplot(winkel,auslenkung+200,'*', 'LineWidth', 8)                        % zum Radius der Schwingscheibe hinzu addieren
hold on
polarplot(winkel_ausgleich,auslenkung_ausgleich+200, 'LineWidth', 2)
rlim([190 210])

set(gca, 'FontSize', 16)
title(['Auslenkungsschaubild Mode ' num2str(modenNr)])

%set(figure(1),'Position',[50 900 1280 980]);