%{
    Mod05_BerDat.m
    
    Ansammlung an MATLAB-Anweisungen zur Bearbeitung von
    Impulshammer-Messungen um diese fr die Modalanalyse aufzubereiten.

    Dieses Skript wertet halbautomatisch Impulshammermessungen fr eine
    Modalanalyse aus.

    Die Ergebnisse werden in der Datenstruktur ergebnis abgelegt.
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 3. Dezember 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

%
% Ermittlung der Frequenzen und Dmpfungen
%
% bernahme der Frequenzen aus dem FRF-Plot

frequenzen = [1222 3223 3704];

%
% den modalfit per Hand ausfhren
% und das subjektiv beste Ergebnis weiter verwenden
%

%[fn, dn] = modalfit(frf,f,fs,100,'FitMethod','lsce', 'FreqRange',[0 5000], 'PhysFreq', frequenzen);
[fn, dn] = modalfit(frf,f,fs,100,'FitMethod','pp', 'FreqRange',[0 5000], 'PhysFreq', frequenzen);
%[fn, dn] = modalfit(frf,f,fs,100,'FitMethod','lsrf', 'FreqRange',[0 5000], 'PhysFreq', frequenzen);

%%
%
% Berechnung der fr die Schwingform bentigten Auslenkung
%

%
%   1. Ermittlung der Betragswerte der bertragungsfunktion bei den 
%   Modal-Frequenzen und Bestimmung der Richtung
%

span = ceil(100/df);        % Spannweite fr die Maxima-Suche
for r=1:length(fn)
                            % Ermittlung des Index fr die Resonanzfrequenz
    idx = ceil(fn(r)/df);
                            % Bestimmung des Betrags der
                            % bertragungsfunktion im Pol
    HxF(r) = max(abs(frf((idx-span):(idx+span),1)));
                            % Ermittlung der Auslenkungsrichtung
    if max(imag(frf(idx-span:idx+span,1))) < 0
        Richtung(r) = (-1);
    else
        Richtung(r) = 1;
    end
    
end

if drivingPoint == position
    %
    %   2. Ermittlung der Auslenkung im Driving-Point
    %   dieser Rechenschritt wird lediglich fr die Auswertung des
    %   Driving-Points durchgefhrt
    %   Gleichung 16.17
    %

    for r=1:length(fn)
        Phi(r) = sqrt(HxF(r)*((fn(r)*2*pi)^2)*sqrt(dn(r)^4+4*dn(r)^2));
    end
else
    %
    %   2. Ermittlung der Auslenkung
    %   dieser Rechenschritt wird fr alles Anschlugpunkte auerhalb des
    %   Driving-Points durchgefhrt
    %   Gleichung 16.18
    %
    
    for r=1:length(fn)
        Phi(r) = sqrt(dn(r)^4+4*dn(r)^2)*HxF(r)*((fn(r)*2*pi)^2)/ergebnis.point(drivingPoint).Phi(r);
    end
end
%%
%
% Datenablage
%

ergebnis.point(position).anregung = anregung;       % gewichtete Zeitreihe der Anregung
ergebnis.point(position).antwort = antwort;         % gewichtete Zeitreihe der Antwort
ergebnis.point(position).frf = frf;                 % berechnete bertragungsfunktion
ergebnis.point(position).f = f;                     % Frequenzvektor
ergebnis.point(position).fn = fn;                   % Frequenzen der Moden
ergebnis.point(position).D = dn;                    % Dmpfung der Moden
ergebnis.point(position).HxF = HxF;                 % Betragswerte der bertragungsfunktion der Moden
ergebnis.point(position).Phi = Phi;                 % Auslenkungen der Moden
ergebnis.point(position).Richtung = Richtung;       % Auslenkungsrichtung
