%{
    Modal04_FRF.m
    
    Ansammlung an MATLAB-Anweisungen zur Bearbeitung von
    Impulshammer-Messungen um diese fr die Modalanalyse aufzubereiten.

    Dieses Skript wertet halbautomatisch Impulshammermessungen fr eine
    Modalanalyse aus.

    Die Ergebnisse werden in der Datenstruktur ergebnis abgelegt.
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 3. Dezember 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

%
%   Bestimmung der bertragungsfunktion und Kohrenz
%   modalfrf(anregung, antwort, fs, blocksize, overlap)
%

noverlap = 0;                           % fr Impulshammer-Daten

[frf, f, coh] = modalfrf(anregung, antwort, fs, blocksize, noverlap);

%
%   Darstellung
%

yyaxis left
plot(f,abs(frf), 'LineWidth', 2);
set(gca, 'yscale', 'log');
axis([0 5000 0.000000001 0.1]);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title('FRF / Coherence');
ylabel('Receptance [m / N]');
xlabel('Frequenz [Hz]');
   
yyaxis right
plot(f,coh, 'LineWidth', 2);
axis([0 5000 0 1.1]);
ylabel('Coherence [---]');

legend('Receptance', 'Coherence', 'Location','southwest');

% modalsd(frf,f,fs, 'FreqRange', [0 5000]);
