%{
    Mod03_ImpulsAufbereiten.m
    
    Ansammlung an MATLAB-Anweisungen zur Bearbeitung von
    Impulshammer-Messungen um diese fr die Modalanalyse aufzubereiten.

    Dieses Skript wertet halbautomatisch Impulshammermessungen fr eine
    Modalanalyse aus.

    Die Ergebnisse werden in der Datenstruktur ergebnis abgelegt.
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 3. Dezember 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

%
%   Impulshhe = Maximalwert des Signals
%   https://de.mathworks.com/help/signal/examples/measurement-of-pulse-and-transition-characteristics.html
%

%
% subjektive Festlegung der vergleichbaren Impulshhen und Impulsbreiten
%

clear anrWindow antWindow anregung antwort;

ImpBreiteMin = 0.115;                % minimale Impulsbreite fr vergleichbare Impulshammermessungen
ImpBreiteMax = 0.13;                % maximale Impulsbreite
ImpHoeheMin = 200;                  % minimale Impulshhe fr vergleichbare Impulshammermessungen
ImpHoeheMax = 300;                  % maximale Impulshhe

%
%   Multiplikation der Zeitreihen mit Gewichtungsfenstern
%   Die Zeitreihen einer Impulshammermessung mssen mit nicht
%   mittenorientierten Gewichtungsfenstern gewichtet werden. Ohne
%   Gewichtung erscheint die Problematik von Leakage und Sprungantworten.
%   Der Impuls selbst ist nur ein sehr kurzes Messsignal. Alles auerhalb
%   des Impulses selbst muss 0 sein, denn dieser Signalanteil ist durch die
%   Bewegung des Impulshammers entstanden und wurde nicht in das Objekt
%   eingeleitet
%

Impulszeit = pre*1000+ImpBreiteMax+1;                   % 1 Millisenke lngeres Gewichtungsfenser als die
                                                        % breiteste IMpulshammer-Messung 
anrWindow = RectExpo(blocksize, fs, 'time', Impulszeit, 1, 3);
antWindow = RectExpo(blocksize, fs, '%', 25, 1, 2);

%anrWindow=rectwin(blocksize);
%antWindow=rectwin(blocksize);
%
%   ber die Funktion modalfrf wird die Kohrenz der Signale zueinander und
%   die bertragungsfunktion ermittelt.
%   Hierzu werden die gewichteten Zeitreihen der Signale
%   hintereinandergehngt - die MATLAB-Funktion erwartet dies so
%

count = 1;
for inc=1:15
    if anregungRoh(position,inc).Breite >= ImpBreiteMin & anregungRoh(position,inc).Breite <= ImpBreiteMax
        if anregungRoh(position,inc).Hoehe >= ImpHoeheMin & anregungRoh(position,inc).Hoehe <= ImpHoeheMax
            if count == 1
                anregung = anregungRoh(position,inc).Data.*anrWindow;
                antwort = antwortRoh(position,inc).Data.*antWindow;
            else
                anregung=vertcat(anregung, anregungRoh(position,inc).Data.*anrWindow);
                antwort=vertcat(antwort, antwortRoh(position,inc).Data.*antWindow);
            end
            count = count +1;
        end
    end
end

%
%   Darstellung des Analysesignals
%

subplot(2,1,1)
plot(anregung, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title('Anregungssignal');
ylabel('Kraft [N]');
set(gca,'xticklabel',[]);

subplot(2,1,2)
plot(antwort, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title('Antwortsignal');
ylabel('Beschleunigung [m/s^2]');
xlabel('Messwerte');

%set(figure(1),'Position',[50 900 1280 980]);