%{
    Mod01_ImpulsRohdaten.m
    
    Ansammlung an MATLAB-Anweisungen zur Bearbeitung von
    Impulshammer-Messungen um diese fr die Modalanalyse aufzubereiten.

    Dieses Skript wertet halbautomatisch Impulshammermessungen fr eine
    Modalanalyse aus.

    Die Ergebnisse werden in der Datenstruktur ergebnis abgelegt.
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 3. Dezember 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

%
%   der erste Berechnungsdruchlauf muss mit dem Driving-Point erfolgen
%

%{
clear;
load('20180208_SchwungscheibenDemo_Orig.mat');

kaliHammer = 3.93;                                          % Kalibrierwert des Impulshammers in mV/N
kaliAufnehmer = 1.04579;                                    % Kalibrierwert des Beschleunigungsaufnehmers in mV/m/s^2

[positionen, schlaege]=size(messung.pos);                   % Ermittlung der Positionsanzahl und Schlaganzahl
                                                            % die Matrix hat den Aufbau Messposition, Schlag-Nr
%}

position = 10;
drivingPoint = 3;


                                                            % Darstellung der Rohdaten
subplot(2,1,1)
hold on
for inc=1:15
    plot(messung.pos(position, inc).Time, messung.pos(position, inc).Data(:,1)*1000/kaliHammer)
    plot(messung.pos(position, inc).Time, messung.pos(position, inc).Data(:,1))
end
hold off
set(gca, 'FontSize', 16)
set(gca, 'ygrid', 'on')
set(gca, 'xgrid', 'on')
title('gemessene Impulshammerschlge')
ylabel('Impulshhe (N)');
axis([0 10 -20 400])
set(gca,'xticklabel',[]);

subplot(2,1,2)
hold on
for inc=1:15
    plot(messung.pos(position, inc).Time, messung.pos(position, inc).Data(:,2)*1000/kaliAufnehmer)
end
hold off
set(gca, 'FontSize', 16)
set(gca, 'ygrid', 'on')
set(gca, 'xgrid', 'on')
title('gemessene Impulsantworten')
ylabel('Impulsantwort (m/s^2)')
xlabel('Zeit [s]')
axis([0 10 -3000 3000])
