%{
    zeitsignal.m
    
    Sammlung von MATLAB-Anweisunen fr die zeitsignalbasierte Signalanalyse
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 4. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

clear;
load('KSMessungen.mat');

%
% Effektivwert einer Schwingung
%

frequenz = 20.2;                      % Frequenz
fs = 51200;                         % Abtastrate
Amplitude = 1;
blocksize = 10 * fs;                % Blocksize = 10 Sekunden
timebase = (0:(blocksize-1)) / fs;
signal = sin(2*pi*frequenz*timebase)*Amplitude; % Sinus mit Frequenz f

plot(timebase, signal, 'LineWidth', 2);
axis([1 2 -1.3 1.3]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Zeitsignal');
ylabel('Amplitude');
xlabel('Zeit [s]');
set(figure(1),'Position',[50 900 1280 480]);

text = ['Effektivwert: ' num2str(rms(signal))];
text = [ text ' +++ Mittelwert der Leistung: ' num2str(rms(signal)^2)];
text = [ text ' +++ Gleichanteil: ' num2str(mean(signal))];

legend(text);

%
% Anwendung auf das Zeitsignal eines Beschleunigungsaufnehmers
%
set(figure(1),'Position',[50 900 1680 880]);
subplot(2,2,1)
signal = messung.m1020.Data(:,1)*1000/messung.Chan1Kali;
timebase = messung.m1020.Time;

plot(timebase, signal, 'LineWidth', 2);
axis([0 20 -10 10]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Lager links 1020/min');
ylabel('Amplitude [m/s^2]');
xlabel('Zeit [s]');

text = [ num2str(rms(signal)) ' m/s^2 RMS'];
text = [ text '\n' num2str(rms(signal)^2) ' (m/s^2)^2 Leistung'];
text = [ text '\n' num2str(mean(signal)) ' m/s^2 DC'];

legend(sprintf(text)); 
%%

subplot(2,2,2)
signal = messung.m4020.Data(:,1)*1000/messung.Chan1Kali;
timebase = messung.m4020.Time;

plot(timebase, signal, 'LineWidth', 2);
axis([0 20 -30 30]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Lager links 4020/min');
ylabel('Amplitude [m/s^2]');
xlabel('Zeit [s]');

text = [ num2str(rms(signal)) ' m/s^2 RMS'];
text = [ text '\n' num2str(rms(signal)^2) ' (m/s^2)^2 Leistung'];
text = [ text '\n' num2str(mean(signal)) ' m/s^2 DC'];

legend(sprintf(text)); 

%%

subplot(2,2,[3 4])
signal = messung.HL.Data(:,1)*1000/messung.Chan1Kali;
timebase = messung.HL.Time;

plot(timebase, signal, 'LineWidth', 2);
axis([0 120 -175 175]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Lager links Drehzahlhochlauf');
ylabel('Amplitude [m/s^2]');
xlabel('Zeit [s]');

text = [ num2str(rms(signal)) ' m/s^2 RMS'];
text = [ text '\n' num2str(rms(signal)^2) ' (m/s^2)^2 Leistung'];
text = [ text '\n' num2str(mean(signal)) ' m/s^2 DC'];

legend(sprintf(text));

%%


%
% Anwendung auf das zeitlich veriante Zeitsignal eines Beschleunigungsaufnehmers
%

signal = messung.HL.Data(:,1)*1000/messung.Chan1Kali;
timebase = messung.HL.Time;

set(figure(1),'Position',[50 900 1680 880]);
subplot(2,1,1)
plot(timebase, signal, 'LineWidth', 2);
axis([0 120 -200 200]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Zeitsignal Beschleunigungssensor Lager links');
ylabel('Amplitude [m/s^2]');
xlabel('Zeit [s]');

text = [ num2str(rms(signal)) ' m/s^2 RMS'];
text = [ text '\n' num2str(rms(signal)^2) ' (m/s^2)^2 Leistung'];
text = [ text '\n' num2str(mean(signal)) ' m/s^2 DC'];

legend(sprintf(text));

%
% gleitender Effektivwert
%

[glEffektiv] = glEffektivwert(signal, messung.fs, 0.125);
%Rechnung dauert recht lange

subplot(2,1,2);
plot(timebase, glEffektiv, 'LineWidth', 2);
axis([0 120 0 25]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Effektivwert Beschleunigungssensor Lager links');
ylabel('Amplitude [m/s^2]');
xlabel('Zeit [s]');
legend('gleitender Effektivwert \tau = 0,125 s');


%%

%
%   Vergleich gleitender Effektivwert mit dt = fs zu dt = 0.001
%

set(figure(1),'Position',[50 900 1680 880]);
subplot(2,1,1);
plot(timebase, glEffektiv, 'LineWidth', 2);
axis([0 120 0 25]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Effektivwert Beschleunigungssensor Lager links');
ylabel('Amplitude [m/s^2]');
xlabel('Zeit [s]');
legend('gleitender Effektivwert \tau = 0,125 s, \Delta t = 1/51200 s');

[glEffektiv2, timeVektor] = glEffektivwert2(signal, timebase, 0.001, fs, 0.125);

subplot(2,1,2);
plot(timeVektor, glEffektiv2, 'LineWidth', 2);
axis([0 120 0 25]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Effektivwert Beschleunigungssensor Lager links');
ylabel('Amplitude [m/s^2]');
xlabel('Zeit [s]');
legend('gleitender Effektivwert \tau = 0,125 s, \Delta t = 0.001 s');