%{
    vergleich_ntelOktav_Spektrum.m
    
    Vergleich einer 1/n-Oktav-Analyse mit der Fouriertransformation
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 15. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html

    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar
%}
%%
% Parameter die als bergabeparameter erforderlich sind

clear;

load('rauschen.mat');

ntel = 3;                       % ntelOktav
filterord = 8;                  % Steilheit der ntelOktavfilter 
f0 = 1000;                      % 1000 Hz als Normfrequenz

[dataFilt, frequenzen] = ntelOktav(data, ntel, filterord, f0, fs);

for inc=1:length(frequenzen)
    [ol, ~] = envelope(dataFilt(:,inc), 640, 'peak');
    level(inc,1) = mean(ol);
end

subplot(2,1,1)
bar(level);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('1/3-Oktav-Analyse "weies Rauschen"');
ylabel('Amplitude');

set(gca, 'XTickLabel', {'0' ...
    num2str(round(frequenzen(1,5))) ...
    num2str(round(frequenzen(1,10))) ...
    num2str(round(frequenzen(1,15))) ...
    num2str(round(frequenzen(1,20))) ...
    num2str(round(frequenzen(1,25))) ...
    num2str(round(frequenzen(1,30)))});

df= 8;
blocksize = ceil(fs/df);
window = hann(blocksize)*blocksize/sum(hann(blocksize));
overlap=ceil(2/3*blocksize);
[s,f,t,p] = spectrogram(data, window, overlap, blocksize, fs);
betrag=mean(2*abs(s)/blocksize,2);

subplot(2,1,2)
plot(f,betrag, 'LineWidth', 2)
axis([0 20000 0 0.2])
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
set(gca, 'xscale', 'log');
xlabel('Frequenz [Hz]');
title('Fouriertransformation "weies Rauschen"');
ylabel('Amplitude');

set(figure(1),'Position',[50 900 1280 980]);