function [dataFilt, frequenzen] = ntelOktav(tdata, ntel, filterord, f0, fs)

% 
% DSPntelOktave
%
% DSPntelOktave are free software
% you can redistribute it and/or modify it under the terms of the 
% GNU General Public License as published by the Free Software Foundation;
% either version 2, or (at your option) any later version.
%
% DSPntelOktave are distributed in the hope that it will be useful, 
% but without any warranty; without even the implied warranty of 
% merchantability or fitness for a particular purpose. See the GNU General
% Public License for more details.
%
%
%   Dipl.-Ing. Armin Rohnen LbA
%   Labor fr Maschinendynamik
%   Hochschule fr angewandte Wissenschaften Mnchen
%   University of applied sciences Munich
%
%   15. August 2018
%%
% Parameter:
%   ntel                ntelOktave (1 fr 1/1, 3 fr 1/3, 6 fr 1/6, ... )
%   filterord           Steilheit der Filterflanken, hohe Ordnungen fr hohe
%                       Flankensteilheit bedeuten jedoch auch hohe
%                       Rechenzeiten Empfehlung: 8
%   f0                  Normfrequenz
%   fs                  Abtasrate des Signals
%   tdata               Zeitsignal fr die 1/n-Oktav-Filterung
%
% Rckgabewerte:
%   dataFilt            Matrix mit den gefilterten Zeitsignalen der ntelOktaven
%   frequenzen          Mittenfrequenzen der ntelOktaven
%   
%%

filterdefs = fdesign.octave(ntel,'Class 1','N,F0',filterord,f0,fs);
frequenzen = validfrequencies(filterdefs);
Nfc = length(frequenzen);

for inc=1:Nfc,
    filterdefs.F0 = frequenzen(inc);
    Hd = design(filterdefs,'butter');
    dataFilt(:,inc) = filter(Hd,tdata);
end