%{
    modulation_eantrieb.m
    
    Bestimmung der Modulationsgrade der Frequenzbnder des Elektroantriebs
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 15. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

clear;
load('15cw.mat');

%
%   1/n-Oktav-Filterung des Signals
%

ntel = 12;                      % ntelOktav
filterord = 8;                  % Steilheit der ntelOktavfilter 
f0 = 1000;                      % 1000 Hz als Normfrequenz

[dataFilt, frequenzen] = ntelOktav(data, ntel, filterord, f0, fs);

[huelle, lo] = envelope(dataFilt, 480, 'peak');

for inc=1:length(frequenzen)
    segment = huelle(144000:830848,inc);
    meanPeaks = mean(findpeaks(segment));
	Mittelwert = mean(segment);
	Modulation(1,inc) = (meanPeaks-Mittelwert)/Mittelwert*100;
end

bar(Modulation);
axis([-1 121 0 60]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Zeitsignal');
ylabel('Modulationsgrad [%]');
xlabel('Frequenz (1/3-Oktaven) [Hz]');

set(gca, 'XTickLabel', {'0' ...
    num2str(round(frequenzen(1,20))) ...
    num2str(round(frequenzen(1,40))) ...
    num2str(round(frequenzen(1,60))) ...
    num2str(round(frequenzen(1,80))) ...
    num2str(round(frequenzen(1,100))) ...
    num2str(round(frequenzen(1,120)))});

set(figure(1),'Position',[50 900 1280 480]);