%{
    huellkurven.m
    
    Sammlung von MATLAB-Anweisunen fr die zeitsignalbasierte Signalanalyse
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 13. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

clear;
load('15cw.mat');

plot(time,data, 'LineWidth', 2);
axis([0 20 -.3 .3]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Zeitsignal Elektroantrieb');
ylabel('Amplitude [Pa]');
xlabel('Zeit [s]');
set(figure(1),'Position',[50 900 1280 480]);

[huelle_oben, huelle_unten] = envelope(data, 4800, 'peak');

hold on
plot(time,huelle_oben, 'LineWidth', 2);
plot(time,huelle_unten, 'LineWidth', 2);
legend('Zeitsignal', 'Umhllende positiv', 'Umhllende negativ');

%
% Berechnung des Modulationsgrads
%

meanPeaks = mean(findpeaks(huelle_oben));            % Mittelwert der Amplitudenspitzen der Umhllenden
Mittelwert = mean(huelle_oben);                      % arithmetischer Mittelwert der Umhllenden
Modulation = (meanPeaks-Mittelwert)/Mittelwert*100;  % Modulationsgrad in %

findpeaks(huelle_oben);
axis([0 inf 0 .3]);
set(gca, 'FontSize', 16);
title('Umhllende des Zeitsignals Elektroantrieb');
ylabel('Amplitude [Pa]');
xlabel('Werte [-]');
set(figure(1),'Position',[50 900 1280 480]);