function [glEffektiv, timeVektor] = glEffektivwert2(signal, timebase, dt, fs, tau)
%{
    glEffektivwert2.m
    
    Funktion zur Berechnung des gleitenden Effektivwertes mit einem definierter Zeitauflsung.

    Signal  :               Signalwerte fr den gleiteden Effektivwert
                            Vektor

    fs      :               Abtastrate des Signals
                            numerischer Wert

    tau     :               Zeitkonstante fr das Abklingverhalten
                            numerischer Wert

    glEffektiv  :           Rckgabevektor mit den Effektivwerten
                            gleiche Lnge wie das Signal

    timeVektor  :           Rckgabevektor mit den zugehrigen Zeitwerten

    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 12. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

blocksize = ceil(tau*fs);               % Anzahl der Messwerte fr Tau
                                        % muss ein ganzzahliger Wert sein
                                        
count=ceil(dt*fs);                      % Gre des "Sprungs"

dimTimebase = size(timebase);
if dimTimebase(2) > 1              % die Signale mssen spaltenorientiert sein
    timebase = timebase';
end

dimSignal = size(signal);
if dimSignal(2) > 1                
    signal = signal';
end

signal = signal.^2/fs;                  % quadrieren des Zeitsignals mit mit dt multiplizieren

for xi=1:blocksize                                  % Fensterfunktion erstellen
    window(xi,1)=exp((-1)*(blocksize-xi)/blocksize);
end


inc = 0;

for pos=1:count:length(signal)
    inc = inc + 1;
    timeVektor(inc,1) = timebase(pos,1);
    if pos==1
        glEffektiv(inc,1) = sqrt(signal(pos,1)*fs);
    else
        if pos-blocksize > 0
            glEffektiv(inc,1) =sqrt(sum(signal(pos-blocksize+1:pos,1).*window)/tau);  
        else
            glEffektiv(inc,1) =sqrt(sum(signal(1:pos,1).*window(blocksize-pos+1:end,1))/(tau*pos/blocksize));  
        end
    end
end