function [glEffektiv] = glEffektivwert(signal, fs, tau)
%{
    glEffektivwert.m
    
    Funktion zur Berechnung des gleitenden Effektivwertes.

    Signal  :               Signalwerte fr den gleiteden Effektivwert
                            Vektor

    fs      :               Abtastrate des Signals
                            numerischer Wert

    tau     :               Zeitkonstante fr das Abklingverhalten
                            numerischer Wert

    glEffektiv  :           Rckgabevektor mit den Effektivwerten
                            gleiche Lnge wie das Signal

    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 4. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

blocksize = ceil(tau*fs);               % Anzahl der Messwerte fr Tau
                                        % juss ein ganzzahliger Wert sein

dimSignal = size(signal);
if dimSignal(2) > 1                     % Signal muss spaltenorientiert sein
    signal = signal';
end

signal = signal.^2/fs;                  % quadrieren des Zeitsignals mit mit dt multiplizieren

for xi=1:blocksize                                  % Fensterfunktion erstellen
    window(xi,1)=exp((-1)*(blocksize-xi)/blocksize);
end

%{
%% Darstellung des Gewichtungsfensters

set(figure(1),'Position',[50 900 1280 480]);
plot(window, 'LineWidth', 2);
axis([0 inf 0 1.2]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Gewichtungsfunktion');
ylabel('Gewichtungsfaktor');
xlabel('\xi');

%}
for pos=1:length(signal)
    if pos==1
        glEffektiv(pos,1) = sqrt(signal(pos,1)*fs);  
    else
        if pos-blocksize > 0
            glEffektiv(pos,1) =sqrt(sum(signal(pos-blocksize+1:pos,1).*window)/tau);  
        else
            glEffektiv(pos,1) =sqrt(sum(signal(1:pos,1).*window(blocksize-pos+1:end,1))/(tau*pos/blocksize));  
        end
    end
end