%{
    crest.m
    
    Sammlung von MATLAB-Anweisunen fr den Crest-Faktor
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 13. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html

    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar

%}
%%

frequenz = 10;                      % Frequenz
fs = 51200;                         % Abtastrate
Amplitude = 1;
blocksize = 1 * fs;                 % Blocksize = 10 Sekunden
timebase = (0:(blocksize-1)) / fs;

signal = sin(2*pi*frequenz*timebase)*Amplitude;

subplot(2,3,1)
plot(timebase, signal, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title(['Sinus k_s = ' num2str(peak2rms(signal))]);
ylabel('Amplitude');
xlabel('Zeit [s]');
axis([0 1 -1.2 1.2])


signal=1/1.5*asin(sin(2*pi*5.*timebase));
subplot(2,3,2)
plot(timebase, signal, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title(['Dreieck k_s = ' num2str(peak2rms(signal))]);
ylabel('Amplitude');
xlabel('Zeit [s]');
axis([0 1 -1.2 1.2])

T0=0.2;
signal=Amplitude*rem(timebase,T0) ./T0;
subplot(2,3,3)
plot(timebase, signal, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title(['Sgezahn k_s = ' num2str(peak2rms(signal))]);
ylabel('Amplitude');
xlabel('Zeit [s]');
axis([0 1 0 1.2])

clear signal;
signal(1,1:ceil(fs/4))=1;
signal(1,end:fs)=0;
subplot(2,3,4)
plot(timebase, signal, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title(['Rechteck k_s = ' num2str(peak2rms(signal))]);
ylabel('Amplitude');
xlabel('Zeit [s]');
axis([0 1 -0.1 1.2])

clear signal;
signal(1,1:ceil(fs/2))=1;
signal(1,end:fs)=0;
subplot(2,3,5)
plot(timebase, signal, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title(['Rechteck k_s = ' num2str(peak2rms(signal))]);
ylabel('Amplitude');
xlabel('Zeit [s]');
axis([0 1 -0.1 1.2])

load('15cw.mat');
subplot(2,3,6)
plot(time,data, 'LineWidth', 2);
axis([0 20 -.3 .3]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title(['Zeitsignal Elektroantrieb k_s = ' num2str(peak2rms(data))]);
ylabel('Amplitude [Pa]');
xlabel('Zeit [s]');


set(figure(1),'Position',[50 900 1280 880]);
