%{
    benachbarteOktave.m
    
    Sammlung von MATLAB-Anweisunen fr die Darstellung benachbarter Oktaven
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 4. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

daten = dataFilt(:,6);
df = 1;
blocksize = ceil(fs/df);
overlap = ceil(2/3*blocksize);
window=hann(blocksize)*blocksize/sum(hann(blocksize));
[s,f,t,p]=spectrogram(daten, window, overlap, blocksize, fs);

betrag=mean(2*abs(s)/blocksize,2);
betrag=betrag/max(betrag);
yy = smooth(betrag,15,'sgolay',3);
yy = smooth(yy,15,'sgolay',3);
yy = smooth(yy,15,'sgolay',3);
yy = smooth(yy,15,'sgolay',3);
plot(f,yy, 'LineWidth', 2)

daten = dataFilt(:,7);
[s,f,t,p]=spectrogram(daten, window, overlap, blocksize, fs);

betrag=mean(2*abs(s)/blocksize,2);
betrag=betrag/max(betrag);
yy = smooth(betrag,15,'sgolay',3);
yy = smooth(yy,15,'sgolay',3);
yy = smooth(yy,15,'sgolay',3);
yy = smooth(yy,15,'sgolay',3);

hold on
plot(f,yy, 'LineWidth', 2)

axis([0 4000 0 1.1])

set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Oktavanalyse');
ylabel('normierte Amplitude');
xlabel('Frequenz [Hz]');
set(figure(1),'Position',[50 900 1280 880]);

legend('Okatve f_0 = 1000 Hz', 'Oktave f_0 = 2000 Hz');