%{
    auto_kreuzkorrelation.m
    
    Sammlung von MATLAB-Anweisunen fr die Auto- und Kreuzkorrelation
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 13. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

%
% Autokorrelation des linken Lagersignals
%

clear;
load('KSMessungen.mat');
x=messung.m4020.Data(:,1)*1000/messung.Chan1Kali;
fs = messung.fs;

[Rxx,tau] = xcorr(x,'coef');
Rxx = Rxx(tau>0);
tau = tau(tau>0);

[Rxx, lo] = envelope(Rxx, 50, 'peak');

subplot(2,1,1)
plot(messung.m4020.Time, x, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('linkes Lagersignal');
ylabel('Beschleuniung [m/s^2]');
xlabel('Zeit [s]');
axis([0 1 -30 30])

subplot(2,1,2)
plot(tau/fs,Rxx,'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Autokorrelation linkes Lagersignal');
ylabel('R_{xx}(\tau)');
xlabel('\tau [s]');
axis([0 1 -0.1 0.5]);

set(figure(1),'Position',[50 900 1280 880]);