%{
    rainflowAuswertung.m
    
    Sammlung von MATLAB-Anweisunen fr die Rainflow-Zhlung
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 16. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%
clear;
load('rainflowdaten.mat');

[c,rm,rmr,rmm] = rainflow(daten);
    
% c - cycle counts, wird nicht bentigt
% rm - Rainflowmatrix 
% rmm - Cycle Average
% rmr - Cycle Range (Amplitude: Spitze - Spitze = Schwingbreite)

klassenhaeufigkeit = sum(rm,2);
% Hufigkeiten der Amplitudenklassen (Spitze - Spitze = Schwingbreite)
    
for inc=1:length(rmr)
    if inc > 1
        summenhaeufigkeit(inc,1) = sum(klassenhaeufigkeit(inc-1:end,1));
    end
end

%
%   Darstellung Zeitsignal
%

plot(time, daten, 'LineWidth', 2);
title('Zeitsignal fr die Rainflow-Zhlung');
ylabel('Amplitude [m/s^2]');
xlabel('Zeit [s]');
set(gca,'FontSize', 16);

set(figure(1),'Position',[50 900 1280 480]);

%
%   Darstellung Klassenhufigkeit
%

bar(klassenhaeufigkeit);
title('Rainflow-Zhlung Klassenhufigkeit');
ylabel('Hufigkeit');
xlabel('Schwingbreite [m/s^2]');
set(gca,'FontSize', 16);
set(gca, 'XTickLabel', {'0' ...
    num2str(rmr(10,1)) ...
    num2str(rmr(20,1)) ...
    num2str(rmr(30,1)) ...
    num2str(rmr(40,1)) ...
    num2str(rmr(50,1)) ...
    num2str(rmr(60,1)) ...
    num2str(rmr(70,1)) ...
    num2str(rmr(end,1))});

set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
set(gca,'YSCALE', 'LOG');
set(figure(1),'Position',[50 900 1280 480]);

%
% Darstellung Summenhufigkeit
%

bar(summenhaeufigkeit);
set(gca,'YSCALE', 'LOG');
title('Amplitudenkollektiv');
xlabel('Schwingbreite [m/s^2]');
ylabel('Summenhufigkeit');
set(gca,'FontSize', 16);
axis([0 80 1 10000]);
set(gca, 'XTickLabel', {'0' ...
    num2str(rmr(10,1)) ...
    num2str(rmr(20,1)) ...
    num2str(rmr(30,1)) ...
    num2str(rmr(40,1)) ...
    num2str(rmr(50,1)) ...
    num2str(rmr(60,1)) ...
    num2str(rmr(70,1)) ...
    num2str(rmr(end,1))});

view(90, -90);                      % tauscht Y mit X Achse

set(figure(1),'Position',[50 900 1280 480]);