%{
    amplitudendichte.m
    
    Sammlung von MATLAB-Anweisung zur Bestimmung und Darstellung der
    Amplitudendichte
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 15. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%

clear;
load('rauschen.mat');

data=data/max(data);
[mu, sigma] = normfit(data);
binwidth = (max(data) - min(data))/20;
xachse = linspace(min(data), max(data), 100);
tachse=0:1/fs:length(data)/fs;
tachse=tachse(1,1:end-1);

subplot(2,2,1)
plot(tachse,data, 'LineWidth', 2);
axis([0 0.1 -1.2 1.2])
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('x(t)');
xlabel('Zeit [s]');


subplot(2,2,2)
hold on
h=histogram(data, 20, 'Orientation', 'horizontal');
plot(normpdf(xachse, mu, sigma)*390000,xachse,'LineWidth',2)
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
xlabel('Hufigkeit');

frequenz = 25;                      % Frequenz
fs = 64000;                         % Abtastrate
Amplitude = 1;
blocksize = 60 * fs;                % Blocksize = 10 Sekunden
timebase = (0:(blocksize-1)) / fs;
signal = sin(2*pi*frequenz*timebase)*Amplitude; % Sinus mit Frequenz f

subplot(2,2,3)
plot(timebase,signal, 'LineWidth', 2);
axis([0 0.1 -1.2 1.2])
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('x(t)');
xlabel('Zeit [s]');

subplot(2,2,4)
histogram(signal, 20, 'Orientation', 'horizontal');
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
xlabel('Hufigkeit');

set(figure(1),'Position',[50 900 1280 980]);