%{
    ueberlappung.m
    
    Sammlung von MATLAB-Anweisungen zur Overlap von FTs
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 21. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%
clear;

N = 4096;
w=hann(N);
w=vertcat(w,w);                 % zwei Fensterlngen
w50=vertcat(w(2049:8192,1),w(1:2048,1));
w50add = w.^2+w50.^2;
w67_1 = vertcat(w(1365:8192,1),w(1:1364,1));
w67_2 = vertcat(w(2731:8192,1),w(1:2730,1));
w67add = w.^2+w67_1.^2+w67_2.^2;
w75_1 = vertcat(w(1025:8192,1),w(1:1024,1));
w75_2 = vertcat(w(2049:8192,1),w(1:2048,1));
w75_3 = vertcat(w(3073:8192,1),w(1:3072,1));
w75add = w.^2+w75_1.^2+w75_2.^2+w75_3.^2;

subplot(8,1,1)
plot(w,'b','LineWidth', 2)
title('Fensterfunktion ohne berlappung')
ylabel('w(N)')
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
axis([0 8192 0 1.5]);

subplot(8,1,2)
plot(w.^2,'b','LineWidth', 2)
title('quadrierte Fensterfunktion ohne berlappung')
ylabel('w^2(N)')
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
axis([0 8192 0 2]);

subplot(8,1,3)
plot(w,'b','LineWidth', 2)
hold on
plot(w50,'b--','LineWidth',2)
title('Fensterfunktion mit 50% berlappung')
ylabel('w(N)')
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
axis([0 8192 0 1.5]);

subplot(8,1,4)
plot(w.^2,'b','LineWidth', 2)
hold on
plot(w50.^2,'b--','LineWidth',2)
plot(w50add,'k','LineWidth',2)
title('quadrierte Fensterfunktion mit 50% berlappung')
ylabel('w^2(N)')
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
axis([0 8192 0 2]);

subplot(8,1,5)
plot(w,'b','LineWidth', 2)
hold on
plot(w67_1,'b--','LineWidth',2)
plot(w67_2,'b:','LineWidth',2)
title('Fensterfunktion mit 66,7% berlappung')
ylabel('w(N)')
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
axis([0 8192 0 1.5]);

subplot(8,1,6)
plot(w.^2,'b','LineWidth', 2)
hold on
plot(w67_1.^2,'b--','LineWidth',2)
plot(w67_2.^2,'b:','LineWidth',2)
plot(w67add,'k','LineWidth',2)
title('quadrierte Fensterfunktion mit 66,7% berlappung')
ylabel('w(N)')
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
axis([0 8192 0 2]);

subplot(8,1,7)
plot(w,'b','LineWidth', 2)
hold on
plot(w75_1,'b--','LineWidth',2)
plot(w75_2,'b:','LineWidth',2)
plot(w75_3,'b-.','LineWidth',2)
title('Fensterfunktion mit 75% berlappung')
ylabel('w(N)')
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
axis([0 8192 0 1.5]);

subplot(8,1,8)
plot(w.^2,'b','LineWidth', 2)
hold on
plot(w75_1.^2,'b--','LineWidth',2)
plot(w75_2.^2,'b:','LineWidth',2)
plot(w75_3.^2,'b-.','LineWidth',2)
plot(w75add,'k','LineWidth',2)
title('quadrierte Fensterfunktion mit 75% berlappung')
ylabel('w(N)')
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
axis([0 8192 0 2]);

set(figure(1),'Position',[50 900 1280 1480]);