%{
    spektrale_groessen.m
    
    Darstellung der Spektralen Gren in MATLAB
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 28. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar
%}
%%

%
%   1. linear gemitteltes Amplitudenspektrum, Betragsspektrum
%

clear;
[x,fs] = audioread('fs_44_1kHz_Oktaven.wav');
x=x*1000;                                       % Umskalierung in mV

df = 0.5;                                       % Frequenzauflsung
N = ceil(fs/df);                                % Anzahl Linien im zweiseitigen Spektrum
T = N / fs;                                     % Blocklnge
overlap = ceil(2/3*N);                          % berlappung
w = hann(N);                                    % Fensterfunktion
FM = sum(w)/N;                                  % Amplitudenkorrektur
PM = sum(w.^2)/N;                               % Leistungskorrektur;
B_eff = PM / (T * FM^2);                        % effektive Bandbreite

[s,f,~,~] = spectrogram(x,w,overlap,N,fs);

sNorm = 2*s/N;

%
%   Darstellung als Scheitelwert
%
MAG=mean(abs(sNorm)/FM,2);                    % Amplitudenspektrum, Betragsspektrum

plot(f,MAG, 'LineWidth', 2);                                    %
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'xscale', 'log');
set(gca, 'ygrid', 'on');

title('Amplitudenspektrum von Testsignal: Oktaven');
xlabel('Frequenz in Hz');
ylabel('$\overline{\hat{x}}$ in mV','Interpreter','latex');
axis([0 20000 0 150]);

set(figure(1),'Position',[50 900 1280 480]);

%
%   Darstellung als Effektivwert
%

MAG_eff=mean(abs(sNorm)/sqrt(2)/FM,2);                   % Amplitudenspektrum, Betragsspektrum

plot(f,MAG_eff, 'LineWidth', 2);                                    %
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'xscale', 'log');
set(gca, 'ygrid', 'on');

title('Amplitudenspektrum von Testsignal: Oktaven');
xlabel('Frequenz in Hz');
ylabel('$\overline{x}_{RMS}$ in mV','Interpreter','latex');
axis([0 20000 0 150]);

set(figure(1),'Position',[50 900 1280 480]);

%
%   Effektivwert in dBV
%

MAG_dBV=20*log10(mean(abs(sNorm)/FM,2)/1000);          % Amplitudenspektrum, Betragsspektrum
                                                       % Umrechnung in dBV, zuvor waren es mV 

plot(f,MAG_dBV, 'LineWidth', 2);                                    %
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'xscale', 'log');
set(gca, 'ygrid', 'on');

title('Amplitudenspektrum von Testsignal: Oktaven');
xlabel('Frequenz in Hz','Interpreter','latex');
ylabel('$\overline{\hat{x}}$ in dBV','Interpreter','latex');
axis([10 20000 -100 0]);

set(figure(1),'Position',[50 900 1280 480]);

%
% Leistungsspektrum, PWR
%

MAG = abs(sNorm)/FM;                                  % Amplitudenspektrum
MAG_eff = MAG/sqrt(2);                                % Amplitudenspektrum als Effektivwerte
PWR = MAG_eff.^2;                                     % Quadrieren zum Leistungsspektrum

PWR = mean(PWR,2);                                    % Mittelwertbildung, da zuvor Spektrogramm  
plot(f,PWR, 'LineWidth', 2);                          %

set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'xscale', 'log');
set(gca, 'ygrid', 'on');

title('Leistungsspektrum von Testsignal: Oktaven');
xlabel('Frequenz in Hz','Interpreter','latex');
ylabel('$\overline{\tilde{x}^2}\ in\ mV^2$','Interpreter','latex');
axis([10 20000 0 8000]);

set(figure(1),'Position',[50 900 1280 480]);

%
%   spektrale Energiedichte ESD, Auto-Power-Spektrum APS
%

MAG = abs(sNorm)/FM;                                  % Amplitudenspektrum
ESD = mean(MAG.^2,2);                                  % spektrale Lesitungsdichte
                                                      % Mittelwertbildung, da zuvor Spektrogramm

plot(f,ESD, 'LineWidth', 2);                            %

set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'xscale', 'log');
set(gca, 'ygrid', 'on');

title('Energiedichtespektrum von Testsignal: Oktaven');
xlabel('Frequenz in Hz','Interpreter','latex');
ylabel('$\overline{\hat{x}^2}\ in\ mV^2$','Interpreter','latex');
axis([10 20000 0 15000]);

set(figure(1),'Position',[50 900 1280 480]);

%
%   Spektrale Leistungsdichte, Autoleistungsspektrum,  
%   Autospektrum,  Autospektraldichte, Power Spectral Density - PSD
%

clear;
load('psd_daten.mat');

df = 1;                                         % Frequenzauflsung
N = ceil(fs/df);                                % Anzahl Linien im zweiseitigen Spektrum
T = N / fs;                                     % Blocklnge
overlap = ceil(2/3*N);                          % berlappung
w = hann(N);                                    % Fensterfunktion
FM = sum(w)/N;                                  % Amplitudenkorrektur
PM = sum(w.^2)/N;                               % Leistungskorrektur;
B_eff = PM / (T * FM^2);                        % effektive Bandbreite

[s,f,~,p] = spectrogram(x,w,overlap,N,fs);
Gxx = mean(p,2);                                % linearer Mittelwert bilden

subplot(4,1,1)
plot(time,x, 'LineWidth', 2)
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title('Testsignal fr PSD Vergleich, Analyse mit 66,7% berlappung und Hanning-Fensterfunktion');
xlabel('Zeit in s');
ylabel('Amplitude m/s^2');
axis([0 20 -100 100]);

subplot(4,1,2)
plot(f,Gxx, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title('PSD aus spectrogram');
xlabel('Frequenz in Hz');
ylabel('PSD in (m/s^2)^2/Hz');
axis([0 50 0 30]);

[Gxx, f] = pwelch(x,w,overlap,N,fs);
subplot(4,1,3)
plot(f,Gxx, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title('PSD aus pwelch');
xlabel('Frequenz in Hz');
ylabel('PSD in (m/s^2)^2/Hz');
axis([0 50 0 30]);

sNorm = 2*s/N;
PWD = (abs(sNorm)/sqrt(2)/FM).^2;                  % Quadrieren des komplexen Spektrums zum Leistungsspektrum
Gxx = mean(PWD / B_eff,2);                         % spektrale Leistungsdichte nach Gleichung 15.65
subplot(4,1,4)
plot(f,Gxx, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title('PSD nach Gleichung 15.65');
xlabel('Frequenz in Hz');
ylabel('PSD in (m/s^2)^2/Hz');
axis([0 50 0 30]);

set(figure(1),'Position',[50 900 1280 1480]);

%
%   Cepstrum  
%

clear;
load('daten_f_cepstrum.mat');

c=rceps(x);
plot(t,c, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title('Cepstrum');
xlabel('Quefrency in s');
ylabel('dB^2');

set(figure(1),'Position',[50 900 1280 1480]);
