%{
    soundAnalyse.m
    
    spektrale Analse eines Sounds
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 13. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html

    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar

%}
%%

clear;
load('sound.mat');

filterdefs = fdesign.octave(3,'Class 1','N,F0',8,1000,fs);
frequenzen = validfrequencies(filterdefs);
Nfc = length(frequenzen);

tau = 0.1;                              % Zeitkonstante
T = ceil(fs/tau);
zeit=(0:0.01:length(data)/fs);

for inc=1:Nfc
    filterdefs.F0 = frequenzen(inc);
    Hd = design(filterdefs,'butter');
    datenFilter = filter(Hd,data(:,1));
    
    for inc2=1:length(zeit)
        anfang = ceil((zeit(1,inc2)-tau/2)*fs);
        ende = ceil((zeit(1,inc2)+tau/2)*fs);
        if ende <= length(data) && anfang > 0
            ntelOktaven(inc2,inc) = rms(datenFilter(anfang:ende,1));
        else
            ntelOktaven(inc2,inc) = 0;
        end
    end
end

xVektor = (1:Nfc);

mesh(xVektor, zeit, ntelOktaven);
colormap(parula);
c=colorbar;
axis([0 30 0 42 0 0.25])
caxis([0 0.25])
ampbeschr = get(c,'ylabel');
set(ampbeschr,'String','Sound');
set(ampbeschr, 'FontSize', 18);

set(gca, 'FontSize', 16);
title('Soundanalyse');
xlabel('Frequenz in Hz');

set(gca, 'XTickLabel', {'0'...
    num2str(round(frequenzen(5))) ...
    num2str(round(frequenzen(10))) ...
    num2str(round(frequenzen(15))) ...
    num2str(round(frequenzen(20))) ...
    num2str(round(frequenzen(25))) ...
    num2str(round(frequenzen(29)))});

ylabel('zeit in s');
set(figure(1),'Position',[50 900 1280 980]);
view(10,30)
