%{
    signale_erzeugen.m
    
    Signale erzeuegn und als Audiodatei abspeichern
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 23. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar
%}
%%
clear;
datei = 'fs_44_1kHz_oktaven.wav';
                            % Dateiname
fs = 44100;                 % Abtastfrequenz
Amplitude = 1;              % Signalamplitude
f = [31.5 63 125 250 500 1000 2000 4000 8000];
                            % Frequenzen
T = 30;                     % Blocklnge in Sekunden
N = T * fs;                 % N
t = (0:(N-1)) / fs;

for inc=1:length(f)
    x(:,inc) = sin(2*pi*f(inc)*t)*Amplitude; % Sinus mit Frequenz f
end

signal = sum(x,2);          % Signale addieren
signal=signal/max(signal)/sqrt(2);         
% Signal auf max. Aussteuerung - dB normieren

audiowrite(datei, signal, fs);

%%
%
%   Frequenzssweep erzeugen
%
%
clear;
datei = 'fs_44_1kHz_sweep.wav';
fs = 44100;                 %
T = 30;
N = T * fs;                 
t = (0:(N-1)) / fs;

x = chirp(t,20,30,2500);
audiowrite(datei, x, fs);


%%
%
%   Amplitudenmoduliertes Signal
%
clear;
datei = 'modulation.mat';
                            % Dateiname
fs = 12800;                 % Abtastfrequenz
%
% 1. Modulationssignal
%


Amplitude = 1;              % Signalamplitude
fModulation = [25 40];      % Modulationsfrequenzen, die Frequenzen verdoppeln sich durch die Multiplikation
f = 2000;                   % Trgerfrequenz
T = 30;                     % Blocklnge in Sekunden
N = T * fs;                 % N
t = (0:(N-1)) / fs;

for inc=1:length(fModulation)
    xModulation = sin(2*pi*fModulation(inc)*t)*Amplitude; % Sinus mit Frequenz f
    for inc2=1:length(t)
        x(inc2,inc) = sin(2*pi*f*t(1,inc2))*xModulation(1,inc2);
    end
end

plot(t,x(:,1),'LineWidth', 2)
set(gca, 'FontSize', 16);
title('Amplitudenmodelierte Schwingung');
xlabel('Zeit in s');
ylabel('Amplitude');
axis([1 1.05 -1.2 1.2]);
set(figure(1),'Position',[50 900 1280 480]);