%{
    psd_im_vergleich.m
    
    Test der verschiedenen Funktionen zur Bestimmung von PSDs
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 29. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar
%}
%%

clear;

%
%   1. Test Sinus 10 Hz Amplitude 1
%
%{
frequenz = 10;                            % Frequenz
fs = 4000;                                % Abtastrate
Amplitude = 1;
T = 20;                                    % Blocklnge
N = T * fs;                               % Anzahl Linien 
t = (0:(N-1)) / fs;
x = sin(2*pi*frequenz*t)*Amplitude; % Sinus mit Frequenz f

df = 0.25;                                      % Frequenzauflsung
N = ceil(fs/df);                                % Anzahl Linien im zweiseitigen Spektrum
T = N / fs;                                     % Blocklnge
overlap = ceil(2/3*N);                          % berlappung
w = hann(N);                                    % Fensterfunktion
FM = sum(w)/N;                                  % Amplitudenkorrektur
PM = sum(w.^2)/N;                               % Leistungskorrektur;
B_eff = PM / (T * FM^2);                        % effektive Bandbreite

[s,f,~,p] = spectrogram(x,w,overlap,N,fs);

sNorm = 2*s/N;

PWD = (abs(sNorm)/sqrt(2)/FM).^2;                     % Quadrieren des komplexen Spektrums zum Leistungsspektrum

PSD_KR = mean(PWD / B_eff,2);                         % spektrale Leistungsdichte nach Kuttner/Rohnen
[PSD_Welch, f_welch] = pwelch(x,w,overlap,N, fs);     % PSD nach Welch

subplot(2,6,[1 6])
plot(t,x, 'LineWidth', 2)
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');

title('Zeitsignal f = 10 Hz Amplitude = 1 V fr PSD Vergleich, Analyse mit 66,7% berlappung und Hanning-Fensterfunktion');
xlabel('Zeit in s');
ylabel('Amplitude V');
axis([0 10 -1.2 1.2]);

subplot(2,6,7)
hold on
plot(f,PSD_KR, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title({'PSD' 'nach Kuttner/Rohnen'});
xlabel('Frequenz in Hz');
ylabel('PSD in V^2/Hz');
%legend('df = 0,25 Hz', 'df = 0,5 Hz', 'df = 1 Hz');
legend('df = 0,25 Hz');
axis([0 20 0 2.2]);

subplot(2,6,8)
hold on
plot(f,mean(p,2), 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title({'PSD' 'aus spectrogram'});
xlabel('Frequenz in Hz');
ylabel('PSD in V^2/Hz');
axis([0 20 0 2.2]);

subplot(2,6,9)
hold on
plot(f_welch,mean(PSD_Welch,2), 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title({'PSD' 'aus pwelch'});
xlabel('Frequenz in Hz');
ylabel('PSD in V^2/Hz');
axis([0 20 0 2.2]);

set(figure(1),'Position',[50 900 1280 980]);
%}
%
%   2. Test weies Rauschen generiert mit Adobe Audition
%
%{
[x,fs] = audioread('fs_44_1kHz_wRauschen.wav');
t = (0:(length(x)-1)) / fs;

df = 8;                                      % Frequenzauflsung
N = ceil(fs/df);                                % Anzahl Linien im zweiseitigen Spektrum
T = N / fs;                                     % Blocklnge
overlap = ceil(2/3*N);                          % berlappung
w = hann(N);                                    % Fensterfunktion
FM = sum(w)/N;                                  % Amplitudenkorrektur
PM = sum(w.^2)/N;                               % Leistungskorrektur;
B_eff = PM / (T * FM^2);                        % effektive Bandbreite

[s,f,~,p] = spectrogram(x,w,overlap,N,fs);

sNorm = 2*s/N;

PWD = (abs(sNorm)/sqrt(2)/FM).^2;                     % Quadrieren des komplexen Spektrums zum Leistungsspektrum

PSD_KR = mean(PWD / B_eff,2);                         % spektrale Leistungsdichte nach Kuttner/Rohnen
[PSD_Welch, f_welch] = pwelch(x,w,overlap,N, fs);     % PSD nach Welch

subplot(2,6,[1 6])
plot(t,x, 'LineWidth', 2)
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');

title('Rauschsignal generiert mit Adobe Audition fr PSD Vergleich, Analyse mit 66,7% berlappung und Hanning-Fensterfunktion');
xlabel('Zeit in s');
ylabel('Amplitude V');
axis([0 30 -1.2 1.2]);

subplot(2,6,7)
hold on
plot(f,PSD_KR, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title({'PSD' 'nach Kuttner/Rohnen'});
xlabel('Frequenz in Hz');
ylabel('PSD in V^2/Hz');
legend(['df = ' num2str(df) ' Hz']);
axis([0 20000 0 2.2]);

subplot(2,6,8)
hold on
plot(f,mean(p,2), 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title({'PSD' 'aus spectrogram'});
xlabel('Frequenz in Hz');
ylabel('PSD in V^2/Hz');
axis([0 20 0 2.2]);

subplot(2,6,9)
hold on
plot(f_welch,mean(PSD_Welch,2), 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title({'PSD' 'aus pwelch'});
xlabel('Frequenz in Hz');
ylabel('PSD in V^2/Hz');
axis([0 20 0 2.2]);

set(figure(1),'Position',[50 900 1280 980]);
%}

%
%   3. Test typisches Signal zur Bestimmung eines Lastsignals fr
%   Betriebsfestigkeitsuntersuchungen 
%
clear;
load('psd_daten.mat');

df = 1;                                      % Frequenzauflsung
N = ceil(fs/df);                                % Anzahl Linien im zweiseitigen Spektrum
T = N / fs;                                     % Blocklnge
overlap = ceil(2/3*N);                          % berlappung
w = hann(N);                                    % Fensterfunktion
FM = sum(w)/N;                                  % Amplitudenkorrektur
PM = sum(w.^2)/N;                               % Leistungskorrektur;
B_eff = PM / (T * FM^2);                        % effektive Bandbreite

[s,f,~,p] = spectrogram(x,w,overlap,N,fs);

sNorm = 2*s/N;

PWD = (abs(sNorm)/sqrt(2)/FM).^2;                     % Quadrieren des komplexen Spektrums zum Leistungsspektrum

PSD_KR = mean(PWD / B_eff,2);                         % spektrale Leistungsdichte nach Kuttner/Rohnen
[PSD_Welch, f_welch] = pwelch(x,w,overlap,N, fs);     % PSD nach Welch
[Psmooth,fsmooth,Nw] = apsdsp(x,fs,N,'boxcar');       % PSD nach Anders Brand "smoothed periodogram"

subplot(2,4,[1 4])
plot(time,x, 'LineWidth', 2)
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');

title('Testsignal fr PSD Vergleich, Analyse mit 66,7% berlappung und Hanning-Fensterfunktion');
xlabel('Zeit in s');
ylabel('Amplitude m/s^2');
axis([0 20 -100 100]);

subplot(2,4,5)
hold on
plot(f,PSD_KR, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title({'PSD' 'nach Kuttner/Rohnen'});
xlabel('Frequenz in Hz');
ylabel('PSD in V^2/Hz');
legend('df = 8 Hz', 'df = 4 Hz', 'df = 2 Hz', 'df = 1 Hz');
axis([0 50 0 30]);

subplot(2,4,6)
hold on
plot(f,mean(p,2), 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title({'PSD' 'aus spectrogram'});
xlabel('Frequenz in Hz');
ylabel('PSD in V^2/Hz');
axis([0 50 0 30]);

subplot(2,4,7)
hold on
plot(f_welch,mean(PSD_Welch,2), 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title({'PSD' 'aus pwelch'});
xlabel('Frequenz in Hz');
ylabel('PSD in V^2/Hz');
axis([0 50 0 30]);


subplot(2,4,8)
hold on
plot(fsmooth,Psmooth, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
title({'PSD' 'nach Brand'});
xlabel('Frequenz in Hz');
ylabel('PSD in V^2/Hz');
axis([0 50 0 30]);

set(figure(1),'Position',[50 900 1280 980]);