%{
    modulationsanalyse.m
    
    Durchfhrung einer Modulationsanalyse
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 29. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar
%}
%%

clear;
load('modulation.mat');
data=x(:,1);
%
% Zeitsignal in Frequenzbnder ber 1/n-Oktav-Filterung aufsplitten
% im Beispiel 1/3
%

df = 1;                                         % Frequenzauflsung
N = ceil(fs/df);                                % Anzahl Linien im zweiseitigen Spektrum
T = N / fs;                                     % Blocklnge
overlap = ceil(2/3*N);                          % berlappung
w = hann(N);                                    % Fensterfunktion
FM = sum(w)/N;                                  % Amplitudenkorrektur
NStart = 5*fs;                                  % 5 Sekunden am Anfang und Ende nicht in die Analyse mit einbeziehen
NEnde = length(data)-5*fs;                      % wegen Ein- Ausschwingen der Filter
t=t(1,NStart:NEnde)-t(1,NStart);                % Zeitvektor entsprechend anpassen

filterdefs = fdesign.octave(3,'Class 1','N,F0',8,1000,fs);
frequenzen = validfrequencies(filterdefs);
Nfc = length(frequenzen);

for inc=1:Nfc
    filterdefs.F0 = frequenzen(inc);
    Hd = design(filterdefs,'butter');
    dataFilt = filter(Hd,data);
    [x,~] = envelope(dataFilt(NStart:NEnde,1),32,'peak');% Hllkurve bilden              
    [s,f,~,~] = spectrogram(x-mean(x),w,overlap,N,fs);   % Gleichanteil bestimmen und vom Signal abziehen
    sNorm = 2*s/N;
    MOD(:,inc) = mean(abs(sNorm)/FM,2);
end


xVektor = (1:Nfc);

imagesc(xVektor,f,MOD/rms(data)*100);
colormap(parula);
c=colorbar;
axis([0 30 0 200 0 15])
caxis([0 15])
ampbeschr = get(c,'ylabel');
set(ampbeschr,'String','Modulationsgrad in %');
set(ampbeschr, 'FontSize', 18);

set(gca, 'FontSize', 16);
title('Modulationsanalyse');
xlabel('(Trger)Frequenz in Hz');

set(gca, 'XTickLabel', {'0'...
    num2str(round(frequenzen(5))) ...
    num2str(round(frequenzen(10))) ...
    num2str(round(frequenzen(15))) ...
    num2str(round(frequenzen(20))) ...
    num2str(round(frequenzen(25))) ...
    num2str(round(frequenzen(30)))});

ylabel('Modulationsfrequenz in Hz');
view(0,-90)
set(figure(1),'Position',[50 900 1280 980]);

%
% Beispiel Elektroantrieb
%

clear;
load('15cw.mat');
t=(0:(length(data)-1))/fs;
