%{
    leitfaden.m
    
    Leitfaden fr die Durchfhrung von FTs in MATLAB
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 22. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar
%}
%%

%
%   einzelne FFT
%

clear;

[x,fs] = audioread('fs_44_1kHz_Oktaven.wav');
N=length(x);                                    % Linienanzahl N

s=fft(x);                                       % in MATLAB ohne 1/N realisiert
sNorm=s/N;
stem(abs(sNorm),'LineWidth', 2);                
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('Fourier-Transformation Testsignal: Oktaven');
ylabel('Amplitude');
xlabel('N');
axis([0 N 0 0.1])

set(figure(1),'Position',[50 900 1280 480]);

%%
%
%   Darstellung als einseitiges Spektrum mit Frequenzachse und
%   korrekten Amplituden
%

f = fs*(0:(N/2)-1)/N;                           % Erzeugt den Frequenzvektor, -1 wegen dem Indexshift bei MATLAB
                                                % je Linie ein Sprung von
                                                % df;
sNorm_einseitig = sNorm(1:N/2);                 % nur die Linien 1 bis N/2
subplot(2,1,1)
stem(f,2*abs(sNorm_einseitig),'LineWidth', 2);                
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
set(gca, 'xscale', 'log');
title('Fourier-Transformation Testsignal: Oktaven');
ylabel('Amplitude x_{spitze}'); 
xlabel('Frequenz in Hz');
axis([0 22000 0 0.15]);

[dataFilt, frequenzen] = ntelOktav(x, 1, 8, 1000, fs);  % Kontrolle des Ergebnisses via 1/n-Oktavanalys
                                                        % die Amplituden der Linien im Spektrum mssen
                                                        % den Scheitelwerten der oktavgefilterten Zeitsignale
                                                        % entsprechen
oktavWerte = rms(dataFilt,1)*sqrt(2);                   % 
subplot(2,1,2)
bar(oktavWerte);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
title('1/n-Oktavanalyse Testsignal: Oktaven');
ylabel('Amplitude x_{spitze}'); 
xlabel('Frequenz in Hz');
set(gca, 'XTickLabel', { num2str(round(frequenzen(1,1))) ...
    num2str(round(frequenzen(1,2))) ...
    num2str(round(frequenzen(1,3))) ...
    num2str(round(frequenzen(1,4))) ...
    num2str(round(frequenzen(1,5))) ...
    num2str(round(frequenzen(1,6))) ...
    num2str(round(frequenzen(1,7))) ...
    num2str(round(frequenzen(1,8))) ...
    num2str(round(frequenzen(1,9)))});

set(figure(1),'Position',[50 900 1280 980]);


%%
%
%   Spectrogram
%

clear;
[x,fs] = audioread('fs_44_1kHz_Oktaven.wav');

df = 0.5;                                       % Frequenzauflsung
N = ceil(fs/df);                                % Anzahl Linien im zweiseitigen Spektrum
T = N / fs;                                     % Blocklnge
overlap = ceil(2/3*N);                          % berlappung
w = hann(N);                                    % Fensterfunktion
FM = sum(w)/N;                                  % Amplitudenkorrektur
PM = sum(w.^2)/N;                               % Leistungskorrektur;
B_eff = PM / (T * FM^2);                        % effektive Bandbreite

[s,f,t,~] = spectrogram(x,w,overlap,N,fs);

sNorm = s/N;
MAG=2*abs(sNorm)/FM;                            % Amplitudenspektrum

surf(t,f,MAG);                                  %
colormap(spring);
c=colorbar;
set(gca, 'FontSize', 16);
title('Spektrogramm von Testsignal: Oktaven');
xlabel('Zeit in s');
ylabel('Frequenz in Hz');
zlabel('Amplitude');

view(120,20);
axis([0 30 0 20000 0 0.15]);
caxis([0 0.15]);
set(gca, 'yscale', 'log');
set(figure(1),'Position',[50 900 1280 980]);
%%
%
% 96 kHz Testsignal
%
clear;

[x,fs] = audioread('fs_96kHz_Aliasingtest.wav');
df = 0.5;                                       % Frequenzauflsung
N = ceil(fs/df);                                % Anzahl Linien im zweiseitigen Spektrum
T = N / fs;                                     % Blocklnge
overlap = ceil(2/3*N);                          % berlappung
w = hann(N);                                    % Fensterfunktion
FM = sum(w)/N;                                  % Amplitudenkorrektur
PM = sum(w.^2)/N;                               % Leistungskorrektur;
B_eff = PM / (T * FM^2);                        % effektive Bandbreite

[s,f,~,~] = spectrogram(x,w,overlap,N,fs);
sNorm = s/N;
MAG=mean(2*abs(sNorm)/FM,2);                    % Amplitudenspektrum

plot(f,MAG, 'LineWidth',2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
title('f_s = 96 kHz Testsignal');
ylabel('Amplitude');
xlabel('Frequenz in Hz');
axis([0 48000 0 1])
set(figure(1),'Position',[50 900 1280 480]);