%{
    grundlagen_FT.m
    
    Sammlung von MATLAB-Anweisungen fr die Grundlagen der
    Fourier-Transformation
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 19. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%
clear;

%
% Abbildung 15.32
%

frequenz = 23.4375;                            % Frequenz
fs = 1024;                                % Abtastrate
Amplitude = 1;
blocksize = 1 * fs;                       % Blocksize = 1 Sekunden
timebase = (0:(blocksize-1)) / fs;
signal = sin(2*pi*frequenz*timebase)*Amplitude; % Sinus mit Frequenz f

subplot(2,1,1)
plot(timebase,signal, 'lineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('Signalverlauf x(t)');
xlabel('Zeit [ms]');
axis([-0.064 0.640 -1.2 1.2])
set(gca,'xtick',[-0.064:0.064:0.64])
set(gca, 'XTickLabel', { '-64' '0' '64' '128' '192' '256' '320' '384' '448' '512' '576' '640'});

subplot(2,1,2)
signal_f_dft = signal(1,1:64);
signal_f_dft = horzcat(signal_f_dft, signal(1,1:64));
signal_f_dft = horzcat(signal_f_dft, signal(1,1:64));
signal_f_dft = horzcat(signal_f_dft, signal(1,1:64));
signal_f_dft = horzcat(signal_f_dft, signal(1,1:64));
signal_f_dft = horzcat(signal_f_dft, signal(1,1:64));
signal_f_dft = horzcat(signal_f_dft, signal(1,1:64));
signal_f_dft = horzcat(signal_f_dft, signal(1,1:64));
signal_f_dft = horzcat(signal_f_dft, signal(1,1:64));
signal_f_dft = horzcat(signal_f_dft, signal(1,1:64));
signal_f_dft = horzcat(signal_f_dft, signal(1,1:64));
signal_f_dft = horzcat(signal_f_dft, signal(1,1:64));


plot(signal_f_dft, 'lineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('Signalverlauf x(t)');
xlabel('Abtastwerte [k]');
axis([0 704 -1.2 1.2])
set(gca,'xtick',[0:64:702])
set(gca, 'XTickLabel', { '-64' '0' '64' '128' '192' '256' '320' '384' '448' '512' '576' '640'});


set(figure(1),'Position',[50 900 1280 480]);

%
% Abbildung 15.33
%

frequenz = 1;                             % Frequenz
fs = 1024;                                % Abtastrate
Amplitude = 1;
blocksize = 1 * fs;                       % Blocksize = 1 Sekunden
timebase = (0:(blocksize-1)) / fs;
signal = cos(2*pi*frequenz*timebase)*Amplitude; % Sinus mit Frequenz f

subplot(1,2,1)
plot(timebase,signal, 'LineWidth', 2);
signal_f_dft(1,1)=signal(1,1);
timebase_f_dft(1,1)=timebase(1,1);
signal_f_dft(1,2)=signal(1,129);
timebase_f_dft(1,2)=timebase(1,129);
signal_f_dft(1,3)=signal(1,257);
timebase_f_dft(1,3)=timebase(1,257);
signal_f_dft(1,4)=signal(1,385);
timebase_f_dft(1,4)=timebase(1,385);
signal_f_dft(1,5)=signal(1,513);
timebase_f_dft(1,5)=timebase(1,513);
signal_f_dft(1,6)=signal(1,641);
timebase_f_dft(1,6)=timebase(1,641);
signal_f_dft(1,7)=signal(1,769);
timebase_f_dft(1,7)=timebase(1,769);
signal_f_dft(1,8)=signal(1,897);
timebase_f_dft(1,8)=timebase(1,897);

hold on
plot(timebase_f_dft,signal_f_dft,'o', 'LineWidth', 2);

axis([0 1 -1.2 1.2])
set(gca, 'FontSize', 16);
ylabel('x(t)');
xlabel('Abtastwerte k');
set(gca, 'xgrid', 'on');
set(gca,'ygrid', 'on');
set(gca,'xtick',[0:0.25:1])
set(gca, 'XTickLabel', { '0' '2' '4' '6' '8'});

subplot(1,2,2)
s=fft(signal_f_dft)/8;                      % in MATLAB fehlt 1/N
stem(abs(s), 'LineWidth',2);
set(gca, 'FontSize', 16);
ylabel('Amplitude');
xlabel('Linien n');
set(gca, 'xgrid', 'on');
set(gca,'ygrid', 'on');
axis([1 8.999 0 1.2])
set(gca, 'XTickLabel', { '0' '1' '2' '3' '4' '5' '6' '7' '8' '9'});


set(figure(1),'Position',[50 900 1280 480]);

%
% Abbildung 15.35
%

f = 1;                                    % Frequenz
fs = 1024;                                % Abtastrate
blocksize = 1 * fs;                       % Blocksize = 1 Sekunden
t = (0:(blocksize-1)) / fs;
x1 = 0.75*cos(2*pi*f*t)+0.25*cos(2*pi*3*f*t);
x2 = 0.75*cos(2*pi*f*t)+0.25*cos(2*pi*3*f*t+3/4*pi);

x1_f_dft(1,1)=x1(1,1);                      % diskrete Werte fr die DFT
x1_f_dft(1,2)=x1(1,129);
x1_f_dft(1,3)=x1(1,257);
x1_f_dft(1,4)=x1(1,385);
x1_f_dft(1,5)=x1(1,513);
x1_f_dft(1,6)=x1(1,641);
x1_f_dft(1,7)=x1(1,769);
x1_f_dft(1,8)=x1(1,897);

x2_f_dft(1,1)=x2(1,1);
x2_f_dft(1,2)=x2(1,129);
x2_f_dft(1,3)=x2(1,257);
x2_f_dft(1,4)=x2(1,385);
x2_f_dft(1,5)=x2(1,513);
x2_f_dft(1,6)=x2(1,641);
x2_f_dft(1,7)=x2(1,769);
x2_f_dft(1,8)=x2(1,897);

t_f_dft(1,1)=t(1,1);
t_f_dft(1,2)=t(1,129);
t_f_dft(1,3)=t(1,257);
t_f_dft(1,4)=t(1,385);
t_f_dft(1,5)=t(1,513);
t_f_dft(1,6)=t(1,641);
t_f_dft(1,7)=t(1,769);
t_f_dft(1,8)=t(1,897);

s1=fft(x1_f_dft)/8;                         % DFT durchfhren
s2=fft(x2_f_dft)/8;

subplot(3,2,1)
plot(t,x1, 'LineWidth', 2)
hold on
plot(t_f_dft,x1_f_dft,'o', 'LineWidth', 2)
axis([0 1 -1.2 1.2])
set(gca, 'FontSize', 16);
ylabel('x_1(t)');
xlabel('Abtastwerte k');
set(gca, 'xgrid', 'on');
set(gca,'ygrid', 'on');
set(gca,'xtick',[0:0.25:1])
set(gca, 'XTickLabel', { '0' '2' '4' '6' '8'});

subplot(3,2,2)
plot(t,x2, 'LineWidth', 2)
hold on
plot(t_f_dft,x2_f_dft,'o', 'LineWidth', 2)
axis([0 1 -1.2 1.2])
set(gca, 'FontSize', 16);
ylabel('x_2(t)');
xlabel('Abtastwerte k');
set(gca, 'xgrid', 'on');
set(gca,'ygrid', 'on');
set(gca,'xtick',[0:0.25:1])
set(gca, 'XTickLabel', { '0' '2' '4' '6' '8'});

subplot(3,2,3)
stem(2*abs(s1(1,1:4)), 'LineWidth',2);
set(gca, 'FontSize', 16);
ylabel('Amplitude');
xlabel('Linien n');
set(gca, 'xgrid', 'on');
set(gca,'ygrid', 'on');
axis([1 5 0 1.2])
set(gca, 'XTickLabel', { '0' '1' '2' '3' '4'});

subplot(3,2,4)
stem(2*abs(s2(1,1:4)), 'LineWidth',2);
set(gca, 'FontSize', 16);
ylabel('Amplitude');
xlabel('Linien n');
set(gca, 'xgrid', 'on');
set(gca,'ygrid', 'on');
axis([1 5 0 1.2])
set(gca, 'XTickLabel', { '0' '1' '2' '3' '4'});

subplot(3,2,5)
%stem(angle(s1(1,1:4))), 'LineWidth',2);                 % +pi; -pi = 0
stem([0 0 0 0], 'LineWidth', 2);
set(gca, 'FontSize', 16);
ylabel('Phase');
xlabel('Linien n');
set(gca, 'xgrid', 'on');
set(gca,'ygrid', 'on');
set(gca,'ytick',[0:pi/2:5/4*pi])
axis([1 5 0 5/4*pi])
set(gca, 'XTickLabel', { '0' '1' '2' '3' '4'});
set(gca, 'YTickLabel', { '0' '\pi/2' '\pi'});

subplot(3,2,6)
%stem(angle(s2(1,1:4)), 'LineWidth',2);                 % +pi; -pi = 0
stem([0 0 0 3/4*pi], 'LineWidth', 2);
set(gca, 'FontSize', 16);
ylabel('Phase');
xlabel('Linien n');
set(gca, 'xgrid', 'on');
set(gca,'ygrid', 'on');
set(gca,'ytick',[0:pi/2:5/4*pi])
axis([1 5 0 5/4*pi])
set(gca, 'XTickLabel', { '0' '1' '2' '3' '4'});
set(gca, 'YTickLabel', { '0' '\pi/2' '\pi'});

set(figure(1),'Position',[50 900 1280 1480]);