%{
    fenster.m
    
    Sammlung von MATLAB-Anweisungen fr Leakage und Fensterfunktionen
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 20. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


%}
%%
clear;
set(figure(1),'Position',[50 900 1280 980]);

f = 4;                            % Frequenz
fs = 4096;                        % Abtastrate
N = 1 * fs;                       % T = 1 Sekunde
t = (0:(N-1)) / fs;
x = sin(2*pi*f*t);                % Sinus mit Frequenz f

subplot(2,2,1)
plot(t,x, 'LineWidth', 2);
axis([0 1 -1.2 1.2]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('x(t)');
xlabel('Abtastwerte k');

for inc=1:32
    x_f_fft(1,inc)=x(1,(inc-1)*128+1);
    t_f_fft(1,inc)=t(1,(inc-1)*128+1);
end

hold on
plot(t_f_fft,x_f_fft,'o', 'LineWidth', 2);
set(gca,'xtick',[0:0.25:1]);
set(gca, 'XTickLabel', {'0' '4' '8' '16' '32'});


subplot(2,2,2)
s=fft(x_f_fft)/32;
stem((20*log10(2*abs(s(1,1:16)))+60), 'LineWidth', 2);
axis([1 17 0 80])
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('Pegel in dB');
xlabel('Linien n');
axis([1 17 0 80])
set(gca,'xtick',[1:4:17])
set(gca, 'XTickLabel', {'0' '4' '8' '16' '32'});
set(gca,'ytick',[0:20:80])
set(gca, 'YTickLabel', {'-60' '-40' '-20' '0' '20'});



f = 4.5;                            % Frequenz
fs = 4096;                        % Abtastrate
N = 1 * fs;                       % T = 1 Sekunde
t = (0:(N-1)) / fs;
x = sin(2*pi*f*t);                % Sinus mit Frequenz f

subplot(2,2,3)
plot(t,x, 'LineWidth', 2);
axis([0 1 -1.2 1.2]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('x(t)');
xlabel('Abtastwerte k');

for inc=1:32
    x_f_fft(1,inc)=x(1,(inc-1)*128+1);
    t_f_fft(1,inc)=t(1,(inc-1)*128+1);
end

hold on
plot(t_f_fft,x_f_fft,'o', 'LineWidth', 2);
set(gca,'xtick',[0:0.25:1]);
set(gca, 'XTickLabel', {'0' '4' '8' '16' '32'});


subplot(2,2,4)
s=fft(x_f_fft)/32;
stem((20*log10(2*abs(s(1,1:16)))+60), 'LineWidth', 2);
axis([1 17 0 80])
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('Pegel in dB');
xlabel('Linien n');
set(gca,'xtick',[1:4:17])
set(gca, 'XTickLabel', {'0' '4' '8' '16' '32'});
set(gca,'ytick',[0:20:80])
set(gca, 'YTickLabel', {'-60' '-40' '-20' '0' '20'});
axis([1 17 0 80])


x = sin(2*pi*f*t+pi/2);                % Sinus mit Frequenz f
subplot(1,2,1)
plot(t,x, 'LineWidth', 2);
axis([0 1 -1.2 1.2]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('x(t)');
xlabel('Abtastwerte k');

for inc=1:32
    x_f_fft(1,inc)=x(1,(inc-1)*128+1);
    t_f_fft(1,inc)=t(1,(inc-1)*128+1);
end

hold on
plot(t_f_fft,x_f_fft,'o', 'LineWidth', 2);
set(gca,'xtick',[0:0.25:1]);
set(gca, 'XTickLabel', {'0' '4' '8' '16' '32'});

subplot(1,2,2)
s=fft(x_f_fft)/32;
stem((20*log10(2*abs(s(1,1:16)))+60), 'LineWidth', 2);
axis([1 17 0 80])
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('Pegel in dB');
xlabel('Linien n');
set(gca,'xtick',[1:4:17])
set(gca, 'XTickLabel', {'0' '4' '8' '16' '32'});
set(gca,'ytick',[0:20:80])
set(gca, 'YTickLabel', {'-60' '-40' '-20' '0' '20'});
axis([1 17 0 80])
set(figure(1),'Position',[50 900 1280 480]);

%
% Signale mit Fensterfunktion
%

clear;
set(figure(1),'Position',[50 900 1280 980]);

f = 4;                            % Frequenz
fs = 4096;                        % Abtastrate
N = 1 * fs;                       % T = 1 Sekunde
t = (0:(N-1)) / fs;
x = sin(2*pi*f*t);                % Sinus mit Frequenz f
w = hann(N)';                     % Hanning-Window
x = x.*w;
FM = sum(w)/N;                    % Amplitudenkorrektur

subplot(2,2,1)
plot(t,x, 'LineWidth', 2);
axis([0 1 -1.2 1.2]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('x(t)');
xlabel('Abtastwerte k');

for inc=1:32
    x_f_fft(1,inc)=x(1,(inc-1)*128+1);
    t_f_fft(1,inc)=t(1,(inc-1)*128+1);
end

hold on
plot(t_f_fft,x_f_fft,'o', 'LineWidth', 2);
set(gca,'xtick',[0:0.25:1]);
set(gca, 'XTickLabel', {'0' '4' '8' '16' '32'});
plot(t,w, 'LineWidth', 2);

subplot(2,2,2)
s=fft(x_f_fft)/32;
stem((20*log10(2*abs(s(1,1:16))/FM)+60), 'LineWidth', 2);
axis([1 17 0 80])
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('Pegel in dB');
xlabel('Linien n');
axis([1 17 0 80])
set(gca,'xtick',[1:4:17])
set(gca, 'XTickLabel', {'0' '4' '8' '12' '16'});
set(gca,'ytick',[0:20:80])
set(gca, 'YTickLabel', {'-60' '-40' '-20' '0' '20'});



f = 4.5;                            % Frequenz
fs = 4096;                        % Abtastrate
N = 1 * fs;                       % T = 1 Sekunde
t = (0:(N-1)) / fs;
x = sin(2*pi*f*t);                % Sinus mit Frequenz f
x = x.*w;

subplot(2,2,3)
plot(t,x, 'LineWidth', 2);
axis([0 1 -1.2 1.2]);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('x(t)');
xlabel('Abtastwerte k');

for inc=1:32
    x_f_fft(1,inc)=x(1,(inc-1)*128+1);
    t_f_fft(1,inc)=t(1,(inc-1)*128+1);
end

hold on
plot(t_f_fft,x_f_fft,'o', 'LineWidth', 2);
set(gca,'xtick',[0:0.25:1]);
set(gca, 'XTickLabel', {'0' '4' '8' '16' '32'});
plot(t,w, 'LineWidth', 2);

subplot(2,2,4)
s=fft(x_f_fft)/32;
stem((20*log10(2*abs(s(1,1:16))/FM)+60), 'LineWidth', 2);
axis([1 17 0 80])
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('Pegel in dB');
xlabel('Linien n');
set(gca,'xtick',[1:4:17])
set(gca, 'XTickLabel', {'0' '4' '8' '12' '16'});
set(gca,'ytick',[0:20:80])
set(gca, 'YTickLabel', {'-60' '-40' '-20' '0' '20'});
axis([1 17 0 80])

%
% Fensterung eines Impulses
%

clear;
load('impuls.mat');
N = length(daten);
t = (0:(N-1)) / fs;

subplot(1,2,1)
plot(t,daten, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('Kraft F in N');
xlabel('Zeit in s');
axis([0 1 -50 200]);

w=hann(N);
x=daten.*w;

subplot(1,2,2)
plot(t,x, 'LineWidth', 2);
hold on
plot(t,w*max(daten), 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('Kraft F in N');
xlabel('Zeit in s');
axis([0 1 -50 200]);
legend('gefensterte Kraft', 'Hanning-Fenster');
set(figure(1),'Position',[50 900 1280 480]);
