%{
    diff_int.m
    
    Sammlung von MATLAB-Anweisungen zur Differenzieren und Integrieren von Spektren
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 21. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html

    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar
%}
%%

clear;
load('mittelung.mat');

x=daten(:,9);
fs=1/(zeitvektor(10,1)-zeitvektor(9,1));

df = 0.5;                           % Frequenzauflsung
N = ceil(fs/df);                    % Blocksize
w = hann(N)*N/sum(hann(N));         % Amplitudenkorrigiertes Hanning-Window
overlap = ceil(2/3*N);

[s,f,~,~] = spectrogram(x, w, overlap, N, fs);

op_1=j*2*pi*f;                      % j Omega fr einfache Integration eines linearen Spektrums
op_2=-(j*2*pi*f).^2;                % (j Omega)^2 fr zweifache Integration eines linearen Spektrums

s_INT1 = s./op_1;                   % Integration
s_INT2 = s./op_2;

betrag = mean(2*abs(s)/N,2);            % gemittelte Betragsspektren bilden
betrag_INT1 = mean(2*abs(s_INT1)/N,2);
betrag_INT2 = mean(2*abs(s_INT2)/N,2);

hold on
plot(f,betrag, 'LineWidth', 2);
plot(f,betrag_INT1*1000, 'LineWidth', 2);
plot(f,betrag_INT2*1000000, 'LineWidth', 2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'yscale', 'log');
set(gca, 'xgrid', 'on');
ylabel('Amplitude');
xlabel('Frequenz in Hz');
axis([0 2500 1e-7 1e1])
legend('Beschleunigung in m/s^2', 'Schnelle in mm/s', 'Auslenkung in \mum');

set(figure(1),'Position',[50 900 1280 880]);