%{
    darstellungen.m
    
    Sammlung von MATLAB-Anweisungen zur Darstellung von Spektren
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 21. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar
%}
%%

clear;
load('mittelung.mat');

x=daten(:,9);
fs=1/(zeitvektor(10,1)-zeitvektor(9,1));

df = 0.5;                           % Frequenzauflsung
N = ceil(fs/df);                    % Blocksize
w = hann(N)*N/sum(hann(N));         % Amplitudenkorrigiertes Hanning-Window
overlap = ceil(2/3*N);

[s,f,~,~] = spectrogram(x, w, overlap, N, fs);

betrag = mean(2*abs(s)/N,2);        % gemitteltes Betragspektrum

subplot(3,1,1)
plot(f,betrag, 'LineWidth',2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca, 'xgrid', 'on');
ylabel('Beschleunigung a_{peak} in m/s^2');
xlabel('Frequenz in Hz');
title('Lineare Skalierung der Ordinate und Abszisse');
axis([0 2500 0 5])

subplot(3,1,2)
plot(f,betrag, 'LineWidth',2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca,'yscale', 'log');
set(gca, 'xgrid', 'on');
ylabel('Beschleunigung a_{peak} in m/s^2');
xlabel('Frequenz in Hz');
title('Logarithmische Ordinatenskalierung und lineare Abszissenskalierung');
axis([0 2500 1e-4 1e1])

subplot(3,1,3)
plot(f,betrag, 'LineWidth',2);
set(gca, 'FontSize', 16);
set(gca, 'ygrid', 'on');
set(gca,'yscale', 'log');
set(gca, 'xgrid', 'on');
set(gca, 'xscale', 'log');
ylabel('Beschleunigung a_{peak} in m/s^2');
xlabel('Frequenz in Hz');
title('Logarithmische Skalierung der Ordinate und Abszisse');
axis([10 2500 1e-4 1e1])
set(figure(1),'Position',[50 900 1280 1480]);