%{
    beispiel_motor_3.m
    
    Beispiel Motor 3:
    Schwingungsanalyse von Schwingungssignalen eines zweizylinder Dieselmotors
    Drehzahl Hoch/Runterlauf mit tStep Sttzstellenabstand der Spektren
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 27. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar
%}
%%

clear;
load('motor_hochlauf.mat');

df = 2;                                         % Frequenzauflsung
N = ceil(fs/df);                                % Anzahl Linien im zweiseitigen Spektrum
T = N / fs;                                     % Blocklnge
overlap = ceil(2/3*N);                          % berlappung
dtSpektrum = T*(1-(2/3));                       % 2/3 = 66,7% berlappung  
w = hann(N);                                    % Fensterfunktion
FM = sum(w)/N;                                  % Amplitudenkorrektur
PM = sum(w.^2)/N;                               % Leistungskorrektur;
B_eff = PM / (T * FM^2);                        % effektive Bandbreite

tStep = 0.5;                                    % Sttzstellenabstand auf der Zeitachse in Sekunden
nMittelungen = 6;                               % Anzahl der Mittelungen vor und nach der Sttzstelle
                                                % ergibt als effektiveMittelungen 2*nMittelungen + 1
nStep = ceil(fs*tStep);                         % Sttzstellenabstand auf der Zeitachse in Wertezahl
TA = T+2*nMittelungen*dtSpektrum;               % Mittelungszeit
nTAhalbe = ceil(TA*fs/2);                       % Anzahl der Messwerte fr TA/2

step = 0;
for inc=nTAhalbe+1:nStep:length(signal)-nTAhalbe
    step = step + 1;
    x=signal(inc-nTAhalbe:inc+nTAhalbe-1);
    [s,f,~,~] = spectrogram(x,w,overlap,N,fs);
    MAG(:,step) = mean(2*abs(s/N)/FM,2);        % linearer Mittelwert
    
    if step == 1                                % Zeitvektor erzeugen
        t(1,step) = tStep;
    else
        t(1,step) = t(1,step-1) + tStep;
    end
end

mesh(t,f,MAG);                          %
colormap(spring);
c=colorbar;
ampbeschr = get(c,'ylabel');
set(ampbeschr,'String','Amplitude a in m/s^2');

set(gca, 'FontSize', 16);
title('gemitteltes Spektrogramm Drehzahlhoch-/Drehzahlrunterlauf Dieselmotor mit Sttzstellenabstand dt');
xlabel('Zeit in s');
ylabel('Frequenz in Hz');
axis([0 180 0 250 0 60])
caxis([0 60])
view(90,-90)

set(figure(1),'Position',[50 900 1280 980]);