%{
    beispiel_motor_2.m
    
    Beispiel Motor 2:
    Schwingungsanalyse von Schwingungssignalen eines zweizylinder Dieselmotors
    Drehzahl Hoch/Runterlauf
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 26. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar
%}
%%

clear;
load('motor_hochlauf.mat');
x=signal;

df = 2;                                         % Frequenzauflsung
N = ceil(fs/df);                                % Anzahl Linien im zweiseitigen Spektrum
T = N / fs;                                     % Blocklnge
overlap = ceil(2/3*N);                          % berlappung
w = hann(N);                                    % Fensterfunktion
FM = sum(w)/N;                                  % Amplitudenkorrektur
PM = sum(w.^2)/N;                               % Leistungskorrektur;
B_eff = PM / (T * FM^2);                        % effektive Bandbreite

[s,f,t,~] = spectrogram(x,w,overlap,N,fs);

sNorm = s/N;
MAG=2*abs(sNorm)/FM;                            % Amplitudenspektrum

subplot(3,3,[1 2 4 5])
mesh(t,f,MAG);                          %
colormap(spring);
set(gca, 'FontSize', 16);
title('Spektrogramm Drehzahlhoch-/Drehzahlrunterlauf Dieselmotor');
xlabel('Zeit in s');
zlabel('Amplitude a');
axis([0 180 0 250 0 60])
view(90,-90)

subplot(3,3, [3 6])
plot(MAG(34,:),t, 'LineWidth', 2);
hold on
plot(MAG(68,:),t, 'LineWidth', 2);
title('Frequenzschnitte');
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
xlabel('Amplitude in m/s^2');
c=colorbar;
ampbeschr = get(c,'ylabel');
set(ampbeschr,'String','Amplitude a in m/s^2'); 
caxis([0 60])
axis([0 70 0 180])
legend('66 Hz', '134 Hz')

subplot(3,3, [7 8])
plot(f,MAG(:,840), 'LineWidth', 2);
hold on
plot(f,MAG(:,240), 'LineWidth', 2);
xlabel('Frequenz in Hz');
ylabel('Amplitude in m/s^2');
title('Zeitschnitte');
set(gca, 'FontSize', 16);
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');
axis([0 250 0 70])
legend ('140 s', '40 s');


set(figure(1),'Position',[50 900 1280 980]);

%
%   gemitteltes Spektrogram "gesteppt"
%

[Linien,anzSpektren] = size(MAG);               
step = 0;

for inc=1:14:anzSpektren
    step = step +1 ;
    if inc+13 > anzSpektren
        gemMAG(:,step) = mean(MAG(:,inc:end),2);
        t2(1,step) = t(1,inc)+(t(1,end)-t(1,inc))/2;
    else
        gemMAG(:,step)= mean(MAG(:,inc:inc+13),2);
        t2(1,step) = t(1,inc)+(t(1,inc+13)-t(1,inc))/2;
    end
end

surf(t2,f,gemMAG);                          %
colormap(spring);
c=colorbar;
ampbeschr = get(c,'ylabel');
set(ampbeschr,'String','Amplitude a in m/s^2');

set(gca, 'FontSize', 16);
title('Spektrogramm Drehzahlhoch-/Drehzahlrunterlauf Dieselmotor, jeweils 14 Spektren linear gemittelt');
xlabel('Zeit in s');
ylabel('Frequenz in Hz');
axis([0 180 0 250 0 60])
caxis([0 60])
view(90,-90)

set(figure(1),'Position',[50 900 1280 980]);

%
%   gleitend gemitteltes Spektrogram
%

[Linien,anzSpektren] = size(MAG);               
step = 0;

for inc=7:anzSpektren-7
    step = step + 1;
    gemMAG(:,step)= mean(MAG(:,inc-6:inc+7),2);
    t2(1,step) = t(1,inc-6)+(t(1,inc+7)-t(1,inc-6))/2;
end

mesh(t2,f,gemMAG);                          %
colormap(spring);
c=colorbar;
ampbeschr = get(c,'ylabel');
set(ampbeschr,'String','Amplitude a in m/s^2');

set(gca, 'FontSize', 16);
title('gleitend gemitteltes Spektrogramm Drehzahlhoch-/Drehzahlrunterlauf Dieselmotor');
xlabel('Zeit in s');
ylabel('Frequenz in Hz');
axis([0 180 0 250 0 60])
caxis([0 60])
view(90,-90)

set(figure(1),'Position',[50 900 1280 980]);