%{
    beispiel_motor_1.m
    
    Beispiel Motor 1:
    Schwingungsanalyse von Schwingungssignalen eines zweizylinder Dieselmotors
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 22. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar
%}
%%

clear;
[x,fs]=audioread('motor_konst_skale1000.wav');
x=x*1000;                                           % Signal wurde mit 1/1000 fr das Audioformat skaliert

df = 2;                                         % Frequenzauflsung
N = ceil(fs/df);                                % Anzahl Linien im zweiseitigen Spektrum
T = N / fs;                                     % Blocklnge
overlap = ceil(2/3*N);                          % berlappung
w = hann(N);                                    % Fensterfunktion
FM = sum(w)/N;                                  % Amplitudenkorrektur
PM = sum(w.^2)/N;                               % Leistungskorrektur;
B_eff = PM / (T * FM^2);                        % effektive Bandbreite

[s,f,t,~] = spectrogram(x,w,overlap,N,fs);

sNorm = s/N;
MAG=2*abs(sNorm)/FM;                            % Amplitudenspektrum

surf(t,f,MAG/sqrt(2));                          %
colormap(spring);
c=colorbar;
set(gca, 'FontSize', 16);
title('Spektrogramm Dieselmotor mit konstanter Drehzahl');
xlabel('Zeit in s');
ylabel('Frequenz in Hz');
zlabel('Amplitude a_{RMS}');

view(120,20);
axis([0 20 0 10000 0 5]);
caxis([0 5]);
set(figure(1),'Position',[50 900 1280 980]);

%
%   ber die Messzeit gemittelt
%

plot(f, mean(MAG/sqrt(2),2), 'LineWidth', 2);
set(gca, 'FontSize', 16);
title('Spektrogramm Dieselmotor mit konstanter Drehzahl');
xlabel('Frequenz in Hz');
ylabel('linear gemittelte Amplitude a_{RMS} in m/s^2');
set(gca, 'xgrid', 'on');
set(gca, 'ygrid', 'on');

axis([0 1000 0 15]);
set(figure(1),'Position',[50 900 1280 480]);

%
%   3D-Ansicht von oben im interessanten Frequenzbereich
%

surf(t,f,MAG/sqrt(2));                          %
colormap(spring);
c=colorbar;
set(gca, 'FontSize', 16);
title('Spektrogramm Dieselmotor mit konstanter Drehzahl');
xlabel('Zeit in s');
ylabel('Frequenz in Hz');
zlabel('Amplitude a_{RMS}');

view(90,-90)
axis([0 30 0 200 0 13]);
caxis([0 13]);
set(figure(1),'Position',[50 900 580 980]);