%{
    auswertung_sweep.m
    
    Auswertung eines sich kontinierlich ndernden Signals
    
    Dipl.-Ing. Armin Rohnen LbA
    Hochschule Mnchen - Munich University of Applied Sciences
    Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
    Dachauer Strae 98b, 80335 Mnchen
    eMail: rohnen@hm.edu oder armin@rohnen.net

    Mnchen, 25. August 2018


    Lizenzbedingungen:
    Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
    GNU General Public License, wie von der Free Software Foundation verffentlicht, 
    weitergeben und/oder modifizieren, entweder gem Version 3 der Lizenz oder 
    (nach Ihrer Option) jeder spteren Version.

    Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es Ihnen 
    von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite 
    Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. 
    Details finden Sie in der GNU General Public License.

    GNU General Public License
    http://www.gnu.org/licenses/
    http://www.gnu.de/documents/gpl.de.html


    Tilde: ~   % Zeichen ist auf MAC nicht mehr Verfgbar
%}
%%

clear;
[x,fs]=audioread('fs_44_1kHz_sweep.wav');

df = 0.5;                                       % Frequenzauflsung 1. Versuch
df = 82.5;                                      % Frequenzauflsung 2. Versuch
N = ceil(fs/df);                                % Anzahl Linien im zweiseitigen Spektrum
T = N / fs;                                     % Blocklnge
overlap = ceil(2/3*N);                          % berlappung
w = hann(N);                                    % Fensterfunktion
FM = sum(w)/N;                                  % Amplitudenkorrektur
PM = sum(w.^2)/N;                               % Leistungskorrektur;
B_eff = PM / (T * FM^2);                        % effektive Bandbreite

[s,f,t,~] = spectrogram(x,w,overlap,N,fs);

sNorm = s/N;
MAG=2*abs(sNorm)/FM;                            % Amplitudenspektrum

subplot(3,3,[1 2 4 5])
mesh(t,f,MAG);                          %
colormap(spring);
set(gca, 'FontSize', 16);
title({'Spektrogramm Frequenzsweep' 'Blick von "oben"'});
xlabel('Zeit in s');

view(90,-90);
set(gca, 'YTickLabel', {'' '' '' '' '' '' '' ''});
axis([0 30 0 3000 0 0.1]);
axis([0 30 0 3000 0 1.1]);


subplot(3,3, [3 6])
plot(max(MAG,[],1),t, 'LineWidth', 2);
set(gca, 'FontSize', 16);
axis([0 0.15 0 30]);
axis([0 1.5 0 30]);
title({'Horizontlinie' 'Blick von "rechts"'});
c=colorbar;
caxis([0 0.1]);
caxis([0 1.1]);
ampbeschr = get(c,'ylabel');
set(ampbeschr,'String','Amplitude'); 
set(gca, 'YTickLabel', {'' '' '' '' '' '' ''});

subplot(3,3, [7 8])
plot(f, max(MAG,[],2), 'LineWidth', 2);
set(gca, 'FontSize', 16);
axis([0 3000 0 0.15]);
axis([0 3000 0 1.5]);
xlabel('Frequenz in Hz');

set(figure(1),'Position',[50 900 1280 980]);