% 
% Schnell mal was messen
% MATLAB in der Messtechnik
%
%   rpi_intr - Drehzahlmessung via GPIO-Interrupt am Raspberry Pi
%
% rpi_intr are free software
% you can redistribute it and/or modify it under the terms of the 
% GNU General Public License as published by the Free Software Foundation;
% either version 2, or (at your option) any later version.
%
% rpi_intr are distributed in the hope that it will be useful, 
% but without any warranty; without even the implied warranty of 
% merchantability or fitness for a particular purpose. See the GNU General
% Public License for more details.
%
%
%   Dipl.-Ing. Armin Rohnen LbA
%   Labor fr Maschinendynamik
%   Hochschule fr angewandte Wissenschaften Mnchen
%   University of applied sciences Munich
%
%   2. Februar 2017
%
%
%%

clear;
global rpi;

rpi = raspi('r2d2evo17', 'pi', '......');

%
% bentigte Skripte auf den Raspberry laden
%
putFile(rpi,'read_n');                          % Zeitwerte aus dem FiFo auslesen
putFile(rpi,'intrtest.py');                     % Interruptbehandlung, Zeitwerte in FiFo schreiben


%
% Demogert am Raspberry 
%

configurePin(rpi,19,'DigitalOutput');           % GPIO 19 + Motor 1
configurePin(rpi,20,'DigitalOutput');           % GPIO 20 - Motor 1

%
% Motor einschalten
%

writeDigitalPin(rpi,19,1);                      % startet den Motor
writeDigitalPin(rpi,20,0);

%{
openShell(rpi)                                  % Zum Starten der Interruptbehandlung eine Shell am Raspberry ffnen
pi@r2d2evo17's password:                        % das Passwort zum Einloggen eingeben

nohup ./intrtest.py &                           % den Interrupthandler starten

exit
%}

t = createTimer();
start(t);
