% 
% Schnell mal was messen
% MATLAB in der Messtechnik
%
%   rpi_gpio - GPIO am Raspberry Pi
%
% rpi_gpio are free software
% you can redistribute it and/or modify it under the terms of the 
% GNU General Public License as published by the Free Software Foundation;
% either version 2, or (at your option) any later version.
%
% rpi_gpio are distributed in the hope that it will be useful, 
% but without any warranty; without even the implied warranty of 
% merchantability or fitness for a particular purpose. See the GNU General
% Public License for more details.
%
%
%   Dipl.-Ing. Armin Rohnen LbA
%   Labor fr Maschinendynamik
%   Hochschule fr angewandte Wissenschaften Mnchen
%   University of applied sciences Munich
%
%   8. Februar 2017
%
%
%%

clear;

rpi = raspi('r2d2evo17', 'pi', '.....');

ledBlau = 4;                                    % GPIO Pin fr LED blau
ledGruen = 5;                                   % GPIO Pin fr LED grn
motorPlus = 19;                                 % GPIO Pin fr Motor + Anschluss
motorMinus = 20;                                % GPIO Pin fr Motor - Anschluss

configurePin(rpi,ledBlau,'DigitalOutput');      % GPIO konfiguriern
configurePin(rpi,ledGruen,'DigitalOutput');     

configurePin(rpi,motorPlus,'DigitalOutput');
configurePin(rpi,motorMinus,'DigitalOutput');

%
% Tests
%
%
% LEDs
%

writeDigitalPin(rpi,ledBlau,1);                 % LED blau on
writeDigitalPin(rpi,ledGruen,1);                % LED grn on
pause(3); 
writeDigitalPin(rpi,ledBlau,0);                 % LED blau off
writeDigitalPin(rpi,ledGruen,0);                % LED grn off

%
% Motor on
%
writeDigitalPin(rpi,motorPlus,1);               % Motor Rechtslauf
writeDigitalPin(rpi,motorMinus,0);
pause(3); 
writeDigitalPin(rpi,motorPlus,0);               % Motor Linkslauf
writeDigitalPin(rpi,motorMinus,1);
pause(3); 
writeDigitalPin(rpi,motorPlus,0);               % Motor halt
writeDigitalPin(rpi,motorMinus,0);

%
% kapazitive Tasten
%

%{
scanI2CBus(rpi,'i2c-1')

ans =

  12 cell array

    '0x28'    '0x48'
%}

tasten = i2cdev(rpi,'i2c-1','0x28');        % definiert das Devcie 0x28 als tasten

% writeRegister(myi2cdevice,register,value,dataPrecision)
writeRegister(tasten,0,0,'uint8');

lauf = true;

while lauf
    wert = readRegister(tasten,3,'uint8');
    writeRegister(tasten,0,0,'uint8');
    
    switch (wert)
        case 16
            writeDigitalPin(rpi,motorPlus,0);               % Motor Linkslauf
            writeDigitalPin(rpi,motorMinus,1);
            writeDigitalPin(rpi,ledBlau,1);
            writeDigitalPin(rpi,ledGruen,0);
    
        case 32
            writeDigitalPin(rpi,motorPlus,0);               % Motor halt
            writeDigitalPin(rpi,motorMinus,0);
            lauf = false;
            writeDigitalPin(rpi,ledBlau,0);
            writeDigitalPin(rpi,ledGruen,0);
    
        case 64
            writeDigitalPin(rpi,motorPlus,0);               % Motor halt
            writeDigitalPin(rpi,motorMinus,0);
            lauf = false;
            writeDigitalPin(rpi,ledBlau,0);
            writeDigitalPin(rpi,ledGruen,0);
     
        case 128
            writeDigitalPin(rpi,motorPlus,1);               % Motor rechtslauf
            writeDigitalPin(rpi,motorMinus,0);
            writeDigitalPin(rpi,ledBlau,0);
            writeDigitalPin(rpi,ledGruen,1);
            
     end;
    
     pause(1);                                           % eine Sekunde Pause
end;