% 
% Schnell mal was messen
% MATLAB in der Messtechnik
%
%   rpi_ads1115 - Spannungsmessung mit Raspberry Pi und ADS1115
%
% rpi_ads1115 are free software
% you can redistribute it and/or modify it under the terms of the 
% GNU General Public License as published by the Free Software Foundation;
% either version 2, or (at your option) any later version.
%
% rpi_ads1115 are distributed in the hope that it will be useful, 
% but without any warranty; without even the implied warranty of 
% merchantability or fitness for a particular purpose. See the GNU General
% Public License for more details.
%
%
%   Dipl.-Ing. Armin Rohnen LbA
%   Labor fr Maschinendynamik
%   Hochschule fr angewandte Wissenschaften Mnchen
%   University of applied sciences Munich
%
%   21. April 2017
%
%
%%

clear;

rpi =raspi('r2d2evo17', 'pi', '......');

%{
         DeviceAddress: r2d2evo17                     
                  Port: 18732                         
             BoardName: Raspberry Pi 3 Model B        
         AvailableLEDs: {'led0'}                      
  AvailableDigitalPins: [4,5,6,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27]
  AvailableSPIChannels: {'CE0','CE1'}                 
     AvailableI2CBuses: {'i2c-1'}                     
      AvailableWebcams: {}                            
           I2CBusSpeed: 0 
%}

[i2cAddresses] = scanI2CBus(rpi,'i2c-1')

%{
i2cAddresses =

  13 cell array

    '0x28'    '0x48'    '0x49'
%}

ads1115 = i2cdev(rpi,'i2c-1','0x49');

%{
ads1115 = 

  i2cdev with properties:

        Bus: 'i2c-1'
    Address: '0x49'
%}

%%
%Operational status/single shot conversion start;
os = 128;                       %0: no effect ;
                                %128: single conversion
                                
%Definition of the Analog Input configuration (Channel): mux(mux_nr) set mux_nr
mux(1) = 0;                     %AINp = AIN0 ; AINn = AIN1
mux(2) = 16;                    %AINp = AIN0 ; AINn = AIN3
mux(3) = 32;                    %AINp = AIN1 ; AINn = AIN3
mux(4) = 48;                    %AINp = AIN2 ; AINn = AIN3
mux(5) = 64;                    %AINp = AIN0 ; AINn = GND
mux(6) = 80;                    %AINp = AIN1 ; AINn = GND
mux(7) = 96;                    %AINp = AIN2 ; AINn = GND
mux(8) = 112;                   %AINp = AIN3 ; AINn = GND

%Messbereich
pga(1,1) = 0;                   %Messbereich 1 = 6.144V         
pga(1,2) = 6.144;
pga(2,1) = 2;                   %Messbereich 2 = 4.096V
pga(2,2) = 4.096;
pga(3,1) = 4;                   %Messbereich 3 = 2.048V
pga(3,2) = 2.048;
pga(4,1) = 6;                   %Messbereich 4 = 1.024V
pga(4,2) = 1.028;                         
pga(5,1) = 8;                   %Messbereich 5 = 0.512V         
pga(5,2) = 0.512;
pga(6,1) = 10;                  %Messbereich 6 = 0.256V
pga(6,2) = 0.256;
%%
%Mode
mode = 1;                       %0: multiple, (set SPS)
                                %1: single shot (Einzelmessung)
                                
%%

                                            % der Wert fr das Konfigurationsregister berechnet sich ber die Summe
                                            % aus basis + kanal + messbereich

mux_nr = 4;                     %1: AINp = AIN0 ; AINn = AIN1
                                %2: AINp = AIN0 ; AINn = AIN3
                                %3: AINp = AIN1 ; AINn = AIN3
                                %4: AINp = AIN2 ; AINn = AIN3
                                %5: AINp = AIN0 ; AINn = GND
                                %6: AINp = AIN1 ; AINn = GND
                                %7: AINp = AIN2 ; AINn = GND
                                %8: AINp = AIN3 ; AINn = GND


pga_nr = 6;                     %1: Messbereich = 6.144V         
                                %2: Messbereich = 4.096V
                                %3: Messbereich = 2.048V
                                %4: Messbereich = 1.024V
                                %5: Messbereich = 0.512V
                                %6: Messbereich = 0.256V;

                                %register value
cfg = os + mux(mux_nr) + pga(pga_nr,1) + mode;
                                            % den Konfigurationswert berechnen

writeRegister(ads1115,1,cfg,'uint16');      % und ins Konfigurationsregister schreiben
pause(0.15);                                % Wartezeit zum Setzen des Konfigurationsregisters

hexwert = dec2hex(readRegister(ads1115,0,'uint16'),4);
                                            % den ADC-Wandler-wert auslesen und in Hexadezimal umwandeln
                                            % die Bytes kommen in der falschen Reihenfolge
                                            % es muss Byte1 mit Byte2 getauscht werden
                                            % 
                                            
digits = hex2dec([hexwert(3),hexwert(4),hexwert(1),hexwert(2)]);

if digits > (2^15)
    digits =(-1)*((2^16)-digits);
end;

mess = (pga(pga_nr,2)*digits)/(2^15);
                                            % den Spannungswert berechnen
                                            
