% 
% Schnell mal was messen
% MATLAB in der Messtechnik
%
%   rpi_ads1015 - Spannungsmessung mit Raspberry Pi und ADS1015
%
% rpi_ads1015 are free software
% you can redistribute it and/or modify it under the terms of the 
% GNU General Public License as published by the Free Software Foundation;
% either version 2, or (at your option) any later version.
%
% rpi_ads1015 are distributed in the hope that it will be useful, 
% but without any warranty; without even the implied warranty of 
% merchantability or fitness for a particular purpose. See the GNU General
% Public License for more details.
%
%
%   Dipl.-Ing. Armin Rohnen LbA
%   Labor fr Maschinendynamik
%   Hochschule fr angewandte Wissenschaften Mnchen
%   University of applied sciences Munich
%
%   14. Januar 2017
%
%
%%

clear;

rpi =raspi('r2d2evo17', 'pi', '......');

%{
         DeviceAddress: r2d2evo17                     
                  Port: 18732                         
             BoardName: Raspberry Pi 3 Model B        
         AvailableLEDs: {'led0'}                      
  AvailableDigitalPins: [4,5,6,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27]
  AvailableSPIChannels: {'CE0','CE1'}                 
     AvailableI2CBuses: {'i2c-1'}                     
      AvailableWebcams: {}                            
           I2CBusSpeed: 0 
%}

[i2cAddresses] = scanI2CBus(rpi,'i2c-1')

%{
i2cAddresses =

  12 cell array

    '0x28'    '0x48'
%}

ads1015 = i2cdev(rpi,'i2c-1','0x48');

%{
ads1015 = 

  i2cdev with properties:

        Bus: 'i2c-1'
    Address: '0x48'
%}

% writeRegister(myi2cdevice,register,value,dataPrecision)
                                            %
                                            % Dezimalwerte fr das
                                            % Konfigurationsregister
                                            
basis = 0;                                  % Basiswert, schaltet Comperator-Mode aus

kanal(1) = 192;                             % wert fr Analog in 1
kanal(2) = 208;                             % wert fr Analog in 2
kanal(3) = 224;                             % wert fr Analog in 3
kanal(4) = 240;                             % wert fr Analog in 4

bereich(1,1) = 1;                           % Messbereich 1 = 6.144 V
bereich(1,2) = 6.144;                       %
bereich(2,1) = 3;                           % Messbereich 2 = 4.096 V
bereich(2,2) = 4.096;                       %
bereich(3,1) = 5;                           % Messbereich 3 = 2.048 V
bereich(3,2) = 2.048;                       %
bereich(4,1) = 7;                           % Messbereich 4 = 1.028 V
bereich(4,2) = 1.028;                       %

                                            % der Wert fr das Konfigurationsregister berechnet sich ber die Summe
                                            % aus basis + kanal + messbereich

kanal_nr = 1;                               % Kanal Nr und Messbereich Nr festlegen
bereich_nr = 1;

cfg = basis + kanal(kanal_nr) + bereich(bereich_nr,1);
                                            % den Konfigurationswert berechnen

writeRegister(ads1015,1,cfg,'uint16');      % und ins Konfigurationsregister schreiben
hexwert = dec2hex(readRegister(ads1015,0,'uint16'),4);
                                            % den ADC-Wandler-wert auslesen und in Hexadezimal umwandeln
                                            % die Bytes kommen in der falschen Reihenfolge
                                            % es muss Byte1 mit Byte2 getauscht werden
                                            % beim 12Bit ADC wird zudem das letzte 1/2-Byte ignoriert
                                            % 
                                            
digits = hex2dec([hexwert(3) hexwert(4) hexwert(1)]);
                                            % den ADC-Wandler-wert in Integer (Digits) umwandeln
                                            
if digits>2047
    digits = (-1)*(4096-digits);            % 
end;

messwert = bereich(bereich_nr,2)/2048*digits;
                                            % den Spannungswert berechnen
                                            
