#! /usr/bin/python
import RPi.GPIO as GPIO
import datetime
import time
import os

# Variable definieren
global target
target=os.open('fifo1', os.O_WRONLY)

# SoC als Pinreferenz waehlen
GPIO.setmode(GPIO.BOARD)

# Pin 18 vom SoC als Input deklarieren
GPIO.setup(18, GPIO.IN)  

# ISR
def Interrupt(channel):  

	global target

	# aktuelle Zeit in Mikrosekunden
	t = datetime.datetime.now()
        t2 = (t.hour*60*60*1000000)+(t.minute*60*1000000)+(t.second*1000000)+t.microsecond
        out=str(t2)+'\n'
        os.write(target, out)

# Interrupt Event hinzufuegen. Pin 18, auf fallende Flanke reagieren und ISR "Interrupt" deklarieren
GPIO.add_event_detect(18, GPIO.FALLING, callback = Interrupt, bouncetime = 10)   
  
# Endlosschleife
while True:
	time.sleep(1)

os.close(target)
