
%   
%   Messen mit der OnBoard-Soundkarte
% 
%   Dipl.-Ing. Armin Rohnen LbA
%   Labor fr Maschinendynamik
%   Hochschule fr angewandte Wissenschaften Mnchen
%   University of applied sciences Munich
%
%   November 2016
%
%%

%
%   Messung mit interaktiven Start / Stop sowie Display der Messignale
%
%%
clear;

global fs messgeraet diag1 diag2 kalibrierwert lastSample;

%
%   1. Messung vorbereiten
%

fs = 48000;             % Abtastrate in Messwerte/Sekunde
nBits = 24;             % Auflsung des Messwerts = 24 Bit
nChannels = 2;          % Stereo
ID = 1;                 % ID der Soundkarte
kalibrierwert = 25.4;
                        % der Kalibrierwert des Mikrofons muss aus dem 
                        % Datenblatt des bertragen werden
                        % Die Angabe erfolgt in mV/Pa
                        
messgeraet = audiorecorder(fs,nBits,nChannels,ID);
                        % legt das Messgert an

messgeraet.TimerFcn = 'AudioTimerAction';
                        % Als Call-Funktion wird 'AudioTimerAction'
                        % ausgefhrt
messgeraet.TimerPeriod = 1;
                        % Setzt fr die Zeit ('TimerPeriod') fr den Aufruf des 
                        % Funktions-Calls 'TimerFcn' auf 1 Sekunde
                        
lastSample = 0;         % Index des letzten Messwertes, wird in AudioTimerAction bentigt                        
%
%   2. Plots vorbereiten
%

diag1 = subplot(2,1,1);
diag2 = subplot(2,1,2);

% stellt den Zugriff auf zwei Diagramme zur Verfgung

%
%   3. Messung steuern
%

% record(messgeraet);   % Startet die Aufzeichnung
% pause(messgeraet);    % Pausiert die Aufzeichnung
% resume(messgeraet);   % fhrt die Aufzeichnung weiter
% stop(messgeraet);     % Beendet die Aufzeichnung
%
% messdaten = getaudiodata(messgeraet);
                        % sichert die Messwerte