function AudioTimerAction
%   
%   Messen mit der OnBoard-Soundkarte
% 
%   Dipl.-Ing. Armin Rohnen LbA
%   Labor fr Maschinendynamik
%   Hochschule fr angewandte Wissenschaften Mnchen
%   University of applied sciences Munich
%
%   09. November 2016
%
%%

%
%   Messung mit interaktiven Start / Stop sowie Display der Messignale
%
%%    

global fs messgeraet diag1 diag2 kalibrierwert lastSample;

samples  = getaudiodata(messgeraet);    % die gesamten Messwerte holen

X1 = samples(lastSample+1:lastSample+fs,1)*1000/kalibrierwert;
X2 = samples(lastSample+1:lastSample+fs,2)*1000/kalibrierwert;
                                        % die Messwerte auf den letzten Abschnitt reduzieren dabei
                                        % auf physikalische Werte umrechnen
                                        
lastSample = lastSample + fs;           % Index des letzten bearbeiteten Messwertes hochsetzen
                                        
                                        % Unter Nutzung der Funktion spectrogram die PSD der beiden
                                        % Messkanle ermitteln. Die Blocksize des Signals ist fs lang
[s,f,t,psd1] = spectrogram(X1, rectwin(fs), 0, length(X1), fs);
[s,f,t,psd2] = spectrogram(X2, rectwin(fs), 0, length(X2), fs);

plot(diag1,f,psd1, 'LineWidth', 2);                     % PSDs der Messkanle darstellen 
plot(diag2,f,psd2, 'LineWidth', 2);

set(diag1,'FontSize',14,'XGrid','on','YGrid','on');
axis(diag1, [0 2000 0 500]);
title(diag1,'Frequenzspektrum - Messkanal 1');
ylabel(diag1,'PSD');
xlabel(diag1,'Frequenz [Hz]');

set(diag2,'FontSize',14,'XGrid','on','YGrid','on');
axis(diag2, [0 2000 0 500]);
title(diag2,'Frequenzspektrum - Messkanal 2');
ylabel(diag2,'PSD');
xlabel(diag2,'Frequenz [Hz]');