%
% Schnell mal was messen
% MATLAB in der Messtechnik
%
%   7. Signale erzeugen
%
%%
%
%
%   Dipl.-Ing. Armin Rohnen LbA
%   Hochschule Mnchen - Munich University of Applied Sciences
%   Faktultt 03 - Verbundlabor Fahrzeugtechnik, Akustik und Dynamik
%   Dachauer Strae 98b, 80335 Mnchen
%   Bro / Labor: B0273
%   tel / mobil / online: +49(0) 89 33 98 46 77
%   fax: +49 (0) 89 51 66 24 92
%   skype: armin.rohnen
%   eMail: rohnen@hm.edu
%   www.schwingungsanalyse.com
%
%
%%

fs = 41400;                                     % Abtastrate in Hz
Zeit=12.5;                                      % Lnge des Zeitsignals in Sekunden

fsoll = 125;                                    % Sollfrequenz
asoll = 1.345;                                  % Sollamplitude

time = 0:1/fs:Zeit;                             % Vektor mit Zeitwerten

Signal = asoll * sin(2*pi*fsoll*time);          % Sinussignal mit einstellbarer Amplitude und Frequenz

Signal = Signal';                               % Sinussignal transponiert

plot(time, Signal, 'LineWidth', 2);
set(gca,'FontSize',20,'XGrid','on','YGrid','on');
title('Signale erzeugen');
ylabel('Amplitude [Einheit]');
xlabel('Zeit [s]');
set(figure(1),'Position',[50 900 1680 1080]);


%
%
%%
%
% Signal mit Frequenznderung
%
%

fs = 41400;                                     % Abtastrate in Hz
Zeit=12.5;                                      % Lnge des Zeitsignals in Sekunden

fStart = 12;                                    % Sollfrequenz zum Beginn des Signals
fStop = 1250;                                   % Sollfrequenz zum Ende des Signals
asoll = 1.345;                                  % Sollamplitude

time = 0:1/fs:Zeit;                             % Vektor mit Zeitwerten

Signal = asoll * chirp(time, fStart, Zeit, fStop, 'logarithmic');
                                                % erzeugt einen Signalvektor mit 
                                                % logarithmischer Frequenznderung
Signal = asoll * chirp(time, fStart, Zeit, fStop);                                          
                                                % erzeugt einen Signalvektor mit 
                                                % linearer Frequenznderung
Signal = Signal';

[s,f,t,psd] = spectrogram(Signal,hann(8192),5462,8192,fs);
                                                % berechnet ein Spektrogramm aus dem generierten Signal, die
                                                % Vektoren fr die Frequenzachse (f) und Zeitachse (t) werden
                                                % dabei ebenso gebildet.
                                                % Blocksize = 1024 und Overlap = 682
                                             
                                                
surf(t,f,psd,'EdgeColor','none');  
colormap(parula);
view(100,80);
set(gca,'FontSize',20,'XGrid','on','YGrid','on');
title('Signale erzeugen lin-chirp');
xlabel('Zeit');
ylabel('Frequenz (Hz)');
colorbar;
set(figure(1),'Position',[50 900 1680 1080]);
axis([0 12.5 0 1500 0 0.1]);