%
%
%   Signale ausgeben
%
%   Hochschule Mnchen
%   Labor fr Maschinendynmik
%   Dipl.-Ing. Armin Rohnen LbA
%
%   Mnchen, 3. Januar 2017
%
%   -----------------------------------------------------------------------

clear;
global pos signal

%
% Setup
%%

%
% 1. Messung konfigurieren
%

messgeraet = daq.createSession('directsound');
ch(1)=addAudioInputChannel(messgeraet,'Audio16', '1'); % Analog In 1
ch(1).Name = 'B-Aufnehmer';
ch(2)=addAudioInputChannel(messgeraet,'Audio16', '2'); % Analog In 2
ch(2  ).Name = 'Sollsignal';

%
% 2. Signalgenerator vorbereiten
%

ch(3)=addAudioOutputChannel(messgeraet,'Audio28', '1');
% versteckt sich hinter DirectSound Lautsprecher

messgeraet.Rate = 48000;
fs = messgeraet.Rate;

load('demosignal.mat');         % Demosignal laden
pos = 1;                        % Positionszeiger fr Ausgabestreaming
laenge = 1;                     % Lnge des Ausgabepuffers in Sekunden

streamer(laenge, fs, messgeraet);
                                % legt den ersten Datenblock in den
                                % Ausgabepuffer

%
%   3. Display vorbereiten
% 

[displayHandle] = create_display(messgeraet);

%
%   4. Listener anlegen und Vorgang starten
%

messgeraet.IsContinuous = true;                 % kontiunierliches Messen
messgeraet.NotifyWhenDataAvailableExceeds = ceil(fs/2);
                                                % Anzahl der Messwerte bis zum Auslsen des Event
                                                % 'DataAvailable'
dataListener = addlistener(messgeraet, 'DataAvailable', @(src, event)dispFT(src, event, ch, fs, displayHandle));
                                                % wird ausgefhrt, wenn Daten zur Visualisierung
                                                % vorhanden sind
ausgabeListener = addlistener(messgeraet,'DataRequired',@(src,event)streamer(laenge, fs,messgeraet));
                                                % wird ausgefhrt, wenn das Ausgabesignal am Ende ist

messgeraet.startBackground;                     % startet den Vorgang

%
% 5. Ablaufsteuerung
%

status = 0;

while status < 2
    number = input('neuer Status (2: Stop) :');
    status = number;
    
    if status == 2
        messgeraet.stop;
        delete(dataListener);
        delete(ausgabeListener);
    end;
end;
                                                