function generator(frequenz, amplitude, laenge, fs,  ziel)
%
%
%   Signale ausgeben
%
%   Hochschule Mnchen
%   Labor fr Maschinendynmik
%   Dipl.-Ing. Armin Rohnen LbA
%
%   Mnchen, 3. Januar 2017
%
%   -----------------------------------------------------------------------
%   bergabeparameter:
%   ==================
%
%   frequenz                Sollfrequenz in Hz
%   amplitude               auf das Ausgabegert normierte Sollamplitude
%   laenge                  angetsrebte Lnge des Signals in Sekunden
%                           wird auf die nchstliegende vielfache der
%                           Periodendauer gekrzt
%   fs                      Abtastrate
%   ziel                    daq-Objekt mit dem Ausgabegert
%
%
%%

anzahl_perioden = ceil(laenge*frequenz)-1;  % Anzahl der mglichen Perioden innerhalb der 
                                            % Ziellnge des generierten Signals
n=anzahl_perioden/frequenz*fs;              % Anzahl der Signalwerte
t=(0:n)/fs;                                 % Zeitvektor
signal=amplitude*sin(2*pi*frequenz*t);      % generiertes Signal
signal = signal';                           % Spaltenorientierung

queueOutputData(ziel, signal);              % Signal in die Outputqueue (Puffer) schreiben

%%
%{
plot(t,signal, 'LineWidth', 2);
set(gca, 'FontSize', 20, 'XGrid', 'on', 'YGrid', 'on');
title('generiertes Signal (Beginn)');
ylabel('Amplitude');
xlabel('Zeit [s]');
axis([0 0.1 -1 1]);

title('generiertes Signal (Ende)');
axis([0.9 1 -1 1]);
%}

