function dispData(src, event, ch, fs, displayHandle)
%
%
%   Messwerte ausgeben
%
%   Hochschule Mnchen
%   Labor fr Maschinendynmik
%   Dipl.-Ing. Armin Rohnen LbA
%
%   Mnchen, 3. Januar 2017
%
%   -----------------------------------------------------------------------
%   bergabeparameter:
%   ==================
%
%   ch                      Messkanalinformationen
%   fs                      Abtastrate
%   displayHandle           Handles der einzelnen Displayflchen
%
%%

    time = event.TimeStamps;
    data = event.Data;
    
    for chan=1:length(ch)-1
        L = length(data(:,chan));
        y = fft(data(:,chan));
        f = fs*(0:(L/2))/L;
        P = abs(y(1:L/2+1)/L);                    % einseitiges Betragsspektrum bilden
        P(2:end-1) = 2*P(2:end-1);
        plot(displayHandle(chan,1), f, P,'LineWidth', 2);
        set(displayHandle(chan,1), 'FontSize', 20);
        title(displayHandle(chan,1),ch(chan).Name);
        ylabel(displayHandle(chan,1),'Aussteuerung');
        xlabel(displayHandle(chan,1),'Frequenz [Hz]');
        if chan == 1
            axis(displayHandle(chan,1),[0 200 0 0.2]);
        end;
        if chan == 2
            axis(displayHandle(chan,1),[0 400 0 0.04]);
        end;
   end;
        
end