function [messgeraet, fs, messpunkt] = setup_from_file()
%
%
%   Setup fr Messungen
%
%   Hochschule Mnchen
%   Labor fr Maschinendynmik
%   Dipl.-Ing. Armin Rohnen LbA
%
%   Mnchen, 04. Februar 2016
%
%   -----------------------------------------------------------------------

filename = 'setuptabelle.csv';
delimiter = ',';
startRow = 2;
formatSpec = '%s%s%s%s%s%s%f%s%f%f%f%[^\n\r]';
fileID = fopen(filename,'r');
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'HeaderLines' ,startRow-1, 'ReturnOnError', false);
fclose(fileID);

messgeraet = daq.createSession('ni');

fs = 51200;                               % Abtastrate
messgeraet.Rate = fs;
fs = messgeraet.Rate;

for mp=1:length(dataArray{1,1})
    messpunkt(mp).name = dataArray{1,4}{mp,1};
    messpunkt(mp).sensor = dataArray{1,5}{mp,1};
    messpunkt(mp).EU = dataArray{1,6}{mp,1};
    messpunkt(mp).kalibrierwert = dataArray{1,7}(mp,1);
    messpunkt(mp).kalibrierwert_unit = dataArray{1,8}{mp,1};
    messpunkt(mp).koord_X = dataArray{1,9}(mp,1);
    messpunkt(mp).koord_Y = dataArray{1,10}(mp,1);
    messpunkt(mp).koord_Z = dataArray{1,11}(mp,1);
    addAnalogInputChannel(messgeraet, dataArray{1,1}{mp,1}, dataArray{1,2}{mp,1}, dataArray{1,3}{mp,1}); 
end;